/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.language.AstPrinter;
import graphql.language.Definition;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.script.Bindings;
import manifold.api.fs.IFile;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcLinkedClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcSetProperty;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.json.IJsonBindingsBacked;
import manifold.api.json.Loader;
import manifold.api.json.schema.FormatTypeResolvers;
import manifold.api.json.schema.IJsonFormatTypeResolver;
import manifold.api.json.schema.JsonFormatType;
import manifold.api.templ.DisableStringLiteralTemplates;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.ext.DataBindings;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.IBindingType;
import manifold.ext.api.IProxyFactory;
import manifold.ext.api.Structural;
import manifold.graphql.request.Executor;
import manifold.graphql.type.GqlManifold;
import manifold.util.ManEscapeUtil;
import manifold.util.ManStringUtil;
import manifold.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GqlParentType {
    private final String _fqn;
    private final SchemaDefinition _schemaDefinition;
    private final TypeDefinitionRegistry _registry;
    private final Map<String, OperationDefinition> _operations;
    private final Map<String, FragmentDefinition> _fragments;
    private final IFile _file;
    private final GqlManifold _gqlManifold;
    private final Map<TypeDefinition, Set<UnionTypeDefinition>> _typeToUnions;
    private static Boolean GRAPHQL_LINE_OFFSET_BUG = null;

    GqlParentType(String fqn, SchemaDefinition schemaDefinition, TypeDefinitionRegistry registry, Map<String, OperationDefinition> operations, Map<String, FragmentDefinition> fragments, IFile file, GqlManifold gqlManifold) {
        this._fqn = fqn;
        this._schemaDefinition = schemaDefinition;
        this._registry = registry;
        this._operations = operations;
        this._fragments = fragments;
        this._file = file;
        this._gqlManifold = gqlManifold;
        this._typeToUnions = new HashMap<TypeDefinition, Set<UnionTypeDefinition>>();
    }

    private String getFqn() {
        return this._fqn;
    }

    boolean hasChild(String childName) {
        return this._registry.getType(childName).isPresent();
    }

    void render(StringBuilder sb) {
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(this.getFqn(), AbstractSrcClass.Kind.Interface, this._file).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class.getSimpleName()))).modifiers(1L);
        this.addImports(srcClass);
        this.addInnerTypes(srcClass);
        this.addInnerOperations(srcClass);
        srcClass.render(sb, 0);
    }

    private void addInnerTypes(SrcLinkedClass srcClass) {
        this._registry.types().values().stream().filter(e -> e instanceof UnionTypeDefinition).map(e -> (UnionTypeDefinition)e).forEach(e -> e.getMemberTypes().stream().map(m -> this.findTypeDefinition((Type)m)).forEach(typeDef -> this._typeToUnions.computeIfAbsent((TypeDefinition)typeDef, t -> new HashSet()).add(e)));
        for (TypeDefinition type : this._registry.types().values()) {
            if (type instanceof ObjectTypeDefinition) {
                this.addInnerObjectType((ObjectTypeDefinition)type, srcClass);
                continue;
            }
            if (type instanceof InterfaceTypeDefinition) {
                this.addInnerInterfaceType((InterfaceTypeDefinition)type, srcClass);
                continue;
            }
            if (type instanceof EnumTypeDefinition) {
                this.addInnerEnumType((EnumTypeDefinition)type, srcClass);
                continue;
            }
            if (type instanceof InputObjectTypeDefinition) {
                this.addInnerInputType((InputObjectTypeDefinition)type, srcClass);
                continue;
            }
            if (!(type instanceof UnionTypeDefinition)) continue;
            this.addInnerUnionType((UnionTypeDefinition)type, srcClass);
        }
    }

    private void addInnerOperations(SrcLinkedClass srcClass) {
        for (OperationDefinition operation : this._operations.values()) {
            switch (operation.getOperation()) {
                case QUERY: 
                case MUTATION: {
                    this.addQueryType(operation, srcClass);
                    break;
                }
            }
        }
    }

    private void addProxyFactory(SrcLinkedClass enclosingType) {
        String fqn = enclosingType.getName() + ".ProxyFactory";
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Class).addInterface(new SrcType("IProxyFactory<Map, " + enclosingType.getSimpleName() + ">"))).addMethod(((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(1L)).name("proxy")).returns(new SrcType(enclosingType.getSimpleName()))).addParam("map", Map.class.getSimpleName())).addParam("iface", new SrcType("Class<" + enclosingType.getSimpleName() + ">"))).body(new SrcStatementBlock().addStatement("Bindings bindings = map instanceof Bindings ? (Bindings)map : new DataBindings(map);").addStatement("return new " + enclosingType.getSimpleName() + "() {public Bindings getBindings() {return bindings;}};")));
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addQueryType(OperationDefinition operation, SrcLinkedClass enclosingType) {
        String identifier = SrcLinkedClass.makeIdentifier((String)operation.getName(), (boolean)false);
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)(identifier + ".ProxyFactory.class")))).modifiers(1L);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)operation.getName(), (boolean)false);
        this.addSourcePositionAnnotation(srcClass, (Node)operation, () -> ((OperationDefinition)operation).getName(), (SrcAnnotated)srcClass);
        this.addProxyFactory(srcClass);
        this.addQueryResultType(operation, this.getRoot(operation.getOperation()), srcClass);
        this.addBuilder(srcClass, (Definition)operation);
        this.addCreateMethod(srcClass, (Definition)operation);
        this.addBuilderMethod(srcClass, (Definition)operation);
        this.addRequestMethod(srcClass, operation);
        this.addLoadMethod(srcClass);
        for (VariableDefinition varDef : operation.getVariableDefinitions()) {
            String actualName = this.ensure$included((NamedNode)varDef);
            String propName = SrcLinkedClass.makeIdentifier((String)this.remove$(actualName), (boolean)true);
            SrcType type = this.makeSrcType(varDef.getType(), false);
            StringBuilder propertyType = type.render(new StringBuilder(), 0, false);
            StringBuilder componentType = this.getComponentType(type).render(new StringBuilder(), 0, false);
            SrcGetProperty getter = (SrcGetProperty)((SrcGetProperty)new SrcGetProperty(propName, type).modifiers(0x80000000000L)).body("return (" + propertyType + ")" + RuntimeMethods.class.getSimpleName() + ".coerce(getBindings().get(\"" + this.remove$(actualName) + "\"), " + componentType + ".class);");
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)actualName, (boolean)true);
            this.addSourcePositionAnnotation(srcClass, (Node)varDef, actualName, (SrcAnnotated)getter);
            ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
            SrcSetProperty setter = (SrcSetProperty)((SrcSetProperty)new SrcSetProperty(propName, type).modifiers(0x80000000000L)).body("getBindings().put(\"" + this.remove$(actualName) + "\", " + RuntimeMethods.class.getSimpleName() + ".coerceToBindingValue($value));\n");
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)setter, (String)actualName, (boolean)true);
            this.addSourcePositionAnnotation(srcClass, (Node)varDef, actualName, (SrcAnnotated)setter);
            ((SrcLinkedClass)srcClass.addSetProperty(setter)).modifiers(1L);
        }
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private String remove$(String name) {
        if (name.charAt(0) == '$') {
            return name.substring(1);
        }
        return name;
    }

    private void addRequestMethod(SrcLinkedClass srcClass, OperationDefinition operation) {
        String query = ManEscapeUtil.escapeForJavaStringLiteral((String)AstPrinter.printAstCompact((Node)operation));
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class.getSimpleName()))).modifiers(0x80000000000L)).name("request")).addParam("url", String.class)).returns(new SrcType("Executor<Result>"))).body("return new Executor<Result>(url, \"" + operation.getOperation().name().toLowerCase() + "\", \"" + query + "\", getBindings());"));
    }

    private void addLoadMethod(SrcLinkedClass srcClass) {
        String simpleName = srcClass.getSimpleName();
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("load")).returns(new SrcType("Loader<" + simpleName + ">"))).body("return new Loader<>();");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addCreateMethod(SrcLinkedClass srcClass, Definition definition) {
        String simpleName = srcClass.getSimpleName();
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("create")).returns(simpleName);
        this.addRequiredParameters(definition, (AbstractSrcMethod)method);
        srcClass.addMethod((AbstractSrcMethod)method);
        SrcStatementBlock block = new SrcStatementBlock();
        block.addStatement(simpleName + " thiz = (" + simpleName + ")new DataBindings();");
        for (NamedNode namedNode : this.getDefinitions(definition)) {
            String name = this.remove$(namedNode.getName());
            String Prop = SrcLinkedClass.makeIdentifier((String)name, (boolean)true);
            if (!this.isRequiredVar(namedNode)) continue;
            block.addStatement("thiz.set" + Prop + "(" + name + ");");
        }
        block.addStatement("return thiz;");
        method.body(block);
    }

    private void addBuilderMethod(SrcLinkedClass srcClass, Definition definition) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("builder")).returns(new SrcType("Builder"));
        this.addRequiredParameters(definition, (AbstractSrcMethod)method);
        srcClass.addMethod((AbstractSrcMethod)method);
        StringBuilder sb = new StringBuilder();
        sb.append("return new Builder(");
        int count = 0;
        for (SrcParameter param : method.getParameters()) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(param.getSimpleName());
        }
        sb.append(");");
        method.body(sb.toString());
    }

    private void addRequiredParameters(Definition definition, AbstractSrcMethod method) {
        for (NamedNode namedNode : this.getDefinitions(definition)) {
            if (!this.isRequiredVar(namedNode)) continue;
            Type type = this.getType((Node)namedNode);
            SrcType srcType = this.makeSrcType(type, false);
            method.addParam(this.remove$(namedNode.getName()), srcType);
        }
    }

    private void addBuilder(SrcLinkedClass enclosingType, Definition definition) {
        String fqn = enclosingType.getName() + ".Builder";
        SrcConstructor ctor = (SrcConstructor)new SrcConstructor().modifiers(2L);
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Class).modifiers(8L)).addField((SrcField)new SrcField("_result", new SrcType(enclosingType.getSimpleName())).modifiers(18L))).addConstructor(ctor)).addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(1L)).name("build")).returns(enclosingType.getSimpleName())).body("return _result;"));
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
        this.addRequiredParameters(definition, (AbstractSrcMethod)ctor);
        ctor.body(this.addBuilderConstructorBody(ctor));
        this.addWithMethods(srcClass, definition);
    }

    private String addBuilderConstructorBody(SrcConstructor ctor) {
        StringBuilder sb = new StringBuilder();
        sb.append("_result = create(");
        int count = 0;
        for (SrcParameter param : ctor.getParameters()) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(param.getSimpleName());
        }
        sb.append(");");
        return sb.toString();
    }

    private void addWithMethods(SrcLinkedClass srcClass, Definition definition) {
        for (NamedNode namedNode : this.getDefinitions(definition)) {
            if (this.isRequiredVar(namedNode)) continue;
            Type type = this.getType((Node)namedNode);
            String propName = SrcLinkedClass.makeIdentifier((String)namedNode.getName(), (boolean)true);
            this.addWithMethod(srcClass, namedNode, propName, this.makeSrcType(type, false));
        }
    }

    private List<? extends NamedNode> getDefinitions(Definition def) {
        if (def instanceof OperationDefinition) {
            return ((OperationDefinition)def).getVariableDefinitions();
        }
        if (def instanceof InputObjectTypeDefinition) {
            return ((InputObjectTypeDefinition)def).getInputValueDefinitions();
        }
        if (def instanceof ObjectTypeDefinition) {
            return ((ObjectTypeDefinition)def).getFieldDefinitions();
        }
        throw new IllegalStateException();
    }

    private Type getType(Node def) {
        if (def instanceof VariableDefinition) {
            return ((VariableDefinition)def).getType();
        }
        if (def instanceof InputValueDefinition) {
            return ((InputValueDefinition)def).getType();
        }
        if (def instanceof FieldDefinition) {
            return ((FieldDefinition)def).getType();
        }
        throw new IllegalStateException();
    }

    private void addWithMethod(SrcLinkedClass srcClass, NamedNode node, String propName, SrcType type) {
        String actualName = this.ensure$included(node);
        StringBuilder propertyType = type.render(new StringBuilder(), 0, false);
        SrcMethod withMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(1L)).name("with" + propName)).addParam("$value", type)).returns(new SrcType("Builder"))).body(new SrcStatementBlock().addStatement("_result.getBindings().put(\"" + this.remove$(actualName) + "\", " + RuntimeMethods.class.getSimpleName() + ".coerceToBindingValue($value));").addStatement("return this;"));
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)withMethod, (String)actualName, (boolean)true);
        this.addSourcePositionAnnotation(srcClass, (Node)node, actualName, (SrcAnnotated)withMethod);
        srcClass.addMethod((AbstractSrcMethod)withMethod);
    }

    @NotNull
    private String ensure$included(NamedNode node) {
        String actualName = node.getName();
        if (!actualName.startsWith("$") && node instanceof VariableDefinition) {
            actualName = '$' + actualName;
        }
        return actualName;
    }

    private boolean isRequiredVar(NamedNode node) {
        Type type = this.getType((Node)node);
        return type instanceof NonNullType && (!(node instanceof VariableDefinition) || ((VariableDefinition)node).getDefaultValue() == null);
    }

    private TypeDefinition getRoot(OperationDefinition.Operation operation) {
        Optional<OperationTypeDefinition> rootQueryType;
        TypeDefinition root = null;
        SchemaDefinition schemaDefinition = this.findSchemaDefinition();
        if (schemaDefinition != null && (rootQueryType = schemaDefinition.getOperationTypeDefinitions().stream().filter(e -> e.getName().equals(this.getOperationKey(operation))).findFirst()).isPresent()) {
            TypeName type = rootQueryType.get().getTypeName();
            root = this.findTypeDefinition((Type)type);
        }
        if (root == null) {
            root = this._gqlManifold.findTypeDefinition(this.getOperationDefaultTypeName(operation));
        }
        return root;
    }

    private String getOperationDefaultTypeName(OperationDefinition.Operation operation) {
        return ManStringUtil.capitalize((String)operation.name().toLowerCase());
    }

    @NotNull
    private String getOperationKey(OperationDefinition.Operation operation) {
        return operation.name().toLowerCase();
    }

    private void addQueryResultType(OperationDefinition operation, TypeDefinition ctx, SrcLinkedClass enclosingType) {
        String fqn = enclosingType.getName() + ".Result";
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)"Result.ProxyFactory.class"))).modifiers(1L);
        this.addProxyFactory(srcClass);
        for (Selection member : operation.getSelectionSet().getSelections()) {
            this.addQuerySelection(srcClass, ctx, member);
        }
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addImports(SrcLinkedClass srcClass) {
        srcClass.addImport(Bindings.class);
        srcClass.addImport(Executor.class);
        srcClass.addImport(DataBindings.class);
        srcClass.addImport(IBindingType.class);
        srcClass.addImport(IJsonBindingsBacked.class);
        srcClass.addImport(IProxyFactory.class);
        srcClass.addImport(List.class);
        srcClass.addImport(Loader.class);
        srcClass.addImport(Map.class);
        srcClass.addImport(RuntimeMethods.class);
        srcClass.addImport(NotNull.class);
        srcClass.addImport(ActualName.class);
        srcClass.addImport(DisableStringLiteralTemplates.class);
        srcClass.addImport(SourcePosition.class);
        srcClass.addImport(Structural.class);
        this.importAllOtherGqlTypes(srcClass);
    }

    private void importAllOtherGqlTypes(SrcLinkedClass srcClass) {
        this._gqlManifold.getAllTypeNames().forEach(fqn -> {
            if (!fqn.equals(this.getFqn())) {
                srcClass.addStaticImport(fqn + ".*");
            }
        });
    }

    private void addInnerObjectType(ObjectTypeDefinition type, SrcLinkedClass enclosingType) {
        String identifier = SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)(identifier + ".ProxyFactory.class")))).modifiers(1L);
        this.addUnionInterfaces((TypeDefinition)type, srcClass);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)type.getName(), (boolean)false);
        this.addSourcePositionAnnotation(srcClass, (NamedNode)type, (SrcAnnotated)srcClass);
        List interfaces = type.getImplements();
        this.addInterfaces(srcClass, interfaces);
        this.addProxyFactory(srcClass);
        this.addBuilder(srcClass, (Definition)type);
        this.addCreateMethod(srcClass, (Definition)type);
        this.addBuilderMethod(srcClass, (Definition)type);
        this.addLoadMethod(srcClass);
        List fieldDefinitions = type.getFieldDefinitions();
        for (FieldDefinition member : fieldDefinitions) {
            this.addMember(srcClass, member, (String name) -> fieldDefinitions.stream().anyMatch(f -> f.getName().equals(name)));
        }
        this.addObjectExtensions(type, srcClass);
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addUnionInterfaces(TypeDefinition type, SrcLinkedClass srcClass) {
        Set<UnionTypeDefinition> unions = this._typeToUnions.get(type);
        if (unions != null) {
            unions.forEach(union -> {
                SrcLinkedClass cfr_ignored_0 = (SrcLinkedClass)srcClass.addInterface(SrcLinkedClass.makeIdentifier((String)union.getName(), (boolean)false));
            });
        }
    }

    private void addObjectExtensions(ObjectTypeDefinition type, SrcLinkedClass srcClass) {
        List baseFieldDefinitions = type.getFieldDefinitions();
        List objectExtensions = (List)this._registry.objectTypeExtensions().get(type.getName());
        if (objectExtensions != null) {
            for (ObjectTypeExtensionDefinition ext : objectExtensions) {
                List extFieldDefinitions = ext.getFieldDefinitions();
                for (FieldDefinition member : extFieldDefinitions) {
                    this.addMember(srcClass, member, (String name) -> baseFieldDefinitions.stream().anyMatch(f -> f.getName().equals(name)) || extFieldDefinitions.stream().anyMatch(f -> f.getName().equals(name)));
                }
            }
        }
    }

    private void addInnerInputType(InputObjectTypeDefinition type, SrcLinkedClass enclosingType) {
        String identifier = SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)(identifier + ".ProxyFactory.class")))).modifiers(1L);
        this.addUnionInterfaces((TypeDefinition)type, srcClass);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)type.getName(), (boolean)false);
        this.addSourcePositionAnnotation(srcClass, (NamedNode)type, (SrcAnnotated)srcClass);
        this.addProxyFactory(srcClass);
        this.addBuilder(srcClass, (Definition)type);
        this.addCreateMethod(srcClass, (Definition)type);
        this.addBuilderMethod(srcClass, (Definition)type);
        List inputValueDefinitions = type.getInputValueDefinitions();
        for (InputValueDefinition member : inputValueDefinitions) {
            this.addMember(srcClass, member, (String name) -> inputValueDefinitions.stream().anyMatch(f -> f.getName().equals(name)));
        }
        this.addInputExtensions(type, srcClass);
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addInputExtensions(InputObjectTypeDefinition type, SrcLinkedClass srcClass) {
        List baseInputValueDefinitions = type.getInputValueDefinitions();
        List inputExtensions = (List)this._registry.inputObjectTypeExtensions().get(type.getName());
        if (inputExtensions != null) {
            for (InputObjectTypeExtensionDefinition ext : inputExtensions) {
                List extInputValueDefinitions = ext.getInputValueDefinitions();
                for (InputValueDefinition member : extInputValueDefinitions) {
                    this.addMember(srcClass, member, (String name) -> baseInputValueDefinitions.stream().anyMatch(f -> f.getName().equals(name)) || extInputValueDefinitions.stream().anyMatch(f -> f.getName().equals(name)));
                }
            }
        }
    }

    private void addInnerInterfaceType(InterfaceTypeDefinition type, SrcLinkedClass enclosingType) {
        String identifier = SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)(identifier + ".ProxyFactory.class")))).modifiers(1L);
        this.addUnionInterfaces((TypeDefinition)type, srcClass);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)type.getName(), (boolean)false);
        this.addSourcePositionAnnotation(srcClass, (NamedNode)type, (SrcAnnotated)srcClass);
        this.addProxyFactory(srcClass);
        List fieldDefinitions = type.getFieldDefinitions();
        for (FieldDefinition member : fieldDefinitions) {
            this.addMember(srcClass, member, (String name) -> fieldDefinitions.stream().anyMatch(f -> f.getName().equals(name)));
        }
        this.addInterfaceExtensions(type, srcClass);
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addInterfaceExtensions(InterfaceTypeDefinition type, SrcLinkedClass srcClass) {
        List baseFieldDefinitions = type.getFieldDefinitions();
        List interfaceExtensions = (List)this._registry.interfaceTypeExtensions().get(type.getName());
        if (interfaceExtensions != null) {
            for (InterfaceTypeExtensionDefinition ext : interfaceExtensions) {
                List extFieldDefinitions = ext.getFieldDefinitions();
                for (FieldDefinition member : extFieldDefinitions) {
                    this.addMember(srcClass, member, (String name) -> baseFieldDefinitions.stream().anyMatch(f -> f.getName().equals(name)) || extFieldDefinitions.stream().anyMatch(f -> f.getName().equals(name)));
                }
            }
        }
    }

    private void addInnerEnumType(EnumTypeDefinition type, SrcLinkedClass enclosingType) {
        String identifier = SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(this.getFqn() + '.' + identifier, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Enum).modifiers(1L)).addInterface(IBindingType.class.getSimpleName());
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)type.getName(), (boolean)false);
        this.addSourcePositionAnnotation(srcClass, (NamedNode)type, (SrcAnnotated)srcClass);
        for (EnumValueDefinition member : type.getEnumValueDefinitions()) {
            this.addEnumConstant(identifier, srcClass, member);
        }
        this.addEnumExtensions(type, srcClass);
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("toBindingValue")).modifiers(1L)).returns(Object.class)).body("return name();"));
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addEnumConstant(String identifier, SrcLinkedClass srcClass, EnumValueDefinition member) {
        SrcField enumConst = new SrcField(SrcLinkedClass.makeIdentifier((String)member.getName(), (boolean)false), identifier);
        this.addSourcePositionAnnotation(srcClass, (NamedNode)member, (SrcAnnotated)enumConst);
        srcClass.addEnumConst(enumConst);
    }

    private void addEnumExtensions(EnumTypeDefinition type, SrcLinkedClass srcClass) {
        List enumExtensions = (List)this._registry.enumTypeExtensions().get(type.getName());
        if (enumExtensions != null) {
            String declaringType = SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
            for (EnumTypeExtensionDefinition ext : enumExtensions) {
                for (EnumValueDefinition member : ext.getEnumValueDefinitions()) {
                    this.addEnumConstant(declaringType, srcClass, member);
                }
            }
        }
    }

    private void addInnerUnionType(UnionTypeDefinition type, SrcLinkedClass enclosingType) {
        String identifier = SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)(identifier + ".ProxyFactory.class")))).modifiers(1L);
        this.addUnionInterfaces((TypeDefinition)type, srcClass);
        String lub = this.findLub(type);
        if (lub != null) {
            srcClass.addInterface(SrcLinkedClass.makeIdentifier((String)lub, (boolean)false));
        }
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)type.getName(), (boolean)false);
        this.addSourcePositionAnnotation(srcClass, (NamedNode)type, (SrcAnnotated)srcClass);
        this.addProxyFactory(srcClass);
        this.addIntersectionMethods(srcClass, type);
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addIntersectionMethods(SrcLinkedClass srcClass, UnionTypeDefinition union) {
        HashSet fieldDefs = new HashSet();
        HashMap nameToFieldDef = new HashMap();
        for (Type memberType : union.getMemberTypes()) {
            TypeDefinition typeDef = this.findTypeDefinition(memberType);
            if (!(typeDef instanceof ObjectTypeDefinition)) continue;
            if (fieldDefs.isEmpty()) {
                fieldDefs.addAll(((ObjectTypeDefinition)typeDef).getFieldDefinitions().stream().map(e -> {
                    nameToFieldDef.put(e.getName(), e);
                    return new Pair((Object)e.getName(), (Object)e.getType().toString());
                }).collect(Collectors.toSet()));
                continue;
            }
            fieldDefs.retainAll(((ObjectTypeDefinition)typeDef).getFieldDefinitions().stream().map(e -> new Pair((Object)e.getName(), (Object)e.getType().toString())).collect(Collectors.toSet()));
        }
        fieldDefs.forEach(fieldDef -> this.addMember(srcClass, null, ((FieldDefinition)nameToFieldDef.get(fieldDef.getFirst())).getType(), (String)fieldDef.getFirst(), name -> fieldDefs.stream().anyMatch(f -> ((String)f.getFirst()).equals(name))));
    }

    private void addInterfaces(SrcLinkedClass srcClass, List<Type> interfaces) {
        for (Type iface : interfaces) {
            if (!(iface instanceof TypeName)) continue;
            srcClass.addInterface(SrcLinkedClass.makeIdentifier((String)((TypeName)iface).getName(), (boolean)false));
        }
    }

    private void addQuerySelection(SrcLinkedClass srcClass, TypeDefinition ctx, Selection selection) {
        block4: {
            InlineFragment inlineFragment;
            TypeDefinition fragmentCtx;
            block5: {
                block3: {
                    if (!(selection instanceof Field)) break block3;
                    this.addQueryField(srcClass, ctx, (Field)selection);
                    break block4;
                }
                if (!(selection instanceof FragmentSpread)) break block5;
                FragmentDefinition fragment = this._fragments.get(((FragmentSpread)selection).getName());
                TypeDefinition fragmentCtx2 = this.findTypeDefinition((Type)fragment.getTypeCondition());
                if (fragmentCtx2 == null) break block4;
                for (Selection fragSelection : fragment.getSelectionSet().getSelections()) {
                    this.addQuerySelection(srcClass, fragmentCtx2, fragSelection);
                }
                break block4;
            }
            if (selection instanceof InlineFragment && (fragmentCtx = this.findTypeDefinition((Type)(inlineFragment = (InlineFragment)selection).getTypeCondition())) != null) {
                for (Selection fragSelection : inlineFragment.getSelectionSet().getSelections()) {
                    this.addQuerySelection(srcClass, fragmentCtx, fragSelection);
                }
            }
        }
    }

    private void addQueryField(SrcLinkedClass srcClass, TypeDefinition ctx, Field field) {
        Optional<FieldDefinition> fieldDef;
        String name;
        String alias = field.getAlias();
        String fieldName = field.getName();
        String string = name = alias == null ? fieldName : alias;
        if (ctx instanceof ObjectTypeDefinition) {
            fieldDef = ((ObjectTypeDefinition)ctx).getFieldDefinitions().stream().filter(e -> e.getName().equals(fieldName)).findFirst();
        } else if (ctx instanceof InterfaceTypeDefinition) {
            fieldDef = ((InterfaceTypeDefinition)ctx).getFieldDefinitions().stream().filter(e -> e.getName().equals(fieldName)).findFirst();
        } else {
            if (ctx instanceof UnionTypeDefinition && fieldName.equals("__typename")) {
                String propName = name;
                SrcType type = new SrcType(String.class.getSimpleName());
                propName = SrcLinkedClass.makeIdentifier((String)propName, (boolean)true);
                StringBuilder propertyType = type.render(new StringBuilder(), 0, false);
                StringBuilder componentType = this.getComponentType(type).render(new StringBuilder(), 0, false);
                SrcGetProperty getter = (SrcGetProperty)((SrcGetProperty)new SrcGetProperty(propName, type).modifiers(0x80000000000L)).body("return (" + propertyType + ")" + RuntimeMethods.class.getSimpleName() + ".coerce(getBindings().get(\"" + name + "\"), " + componentType + ".class);");
                SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
                this.addSourcePositionAnnotation(srcClass, (Node)field, name, (SrcAnnotated)getter);
                ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
                return;
            }
            throw new UnsupportedOperationException(ctx.getName());
        }
        SelectionSet childSelections = field.getSelectionSet();
        FieldDefinition fieldDefStatic = fieldDef.orElse(null);
        if (fieldDefStatic == null) {
            return;
        }
        Type type = fieldDefStatic.getType();
        if (childSelections == null || childSelections.getSelections().isEmpty()) {
            String propName = name;
            SrcType type1 = this.makeSrcType(type, false);
            propName = SrcLinkedClass.makeIdentifier((String)propName, (boolean)true);
            StringBuilder propertyType = type1.render(new StringBuilder(), 0, false);
            StringBuilder componentType = this.getComponentType(type1).render(new StringBuilder(), 0, false);
            SrcGetProperty getter = (SrcGetProperty)((SrcGetProperty)new SrcGetProperty(propName, type1).modifiers(0x80000000000L)).body("return (" + propertyType + ")" + RuntimeMethods.class.getSimpleName() + ".coerce(getBindings().get(\"" + name + "\"), " + componentType + ".class);");
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
            this.addSourcePositionAnnotation(srcClass, (Node)field, name, (SrcAnnotated)getter);
            ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
        } else {
            String propName = name;
            SrcType type1 = this.convertSrcType(type, name);
            propName = SrcLinkedClass.makeIdentifier((String)propName, (boolean)true);
            StringBuilder propertyType = type1.render(new StringBuilder(), 0, false);
            StringBuilder componentType = this.getComponentType(type1).render(new StringBuilder(), 0, false);
            SrcGetProperty getter = (SrcGetProperty)((SrcGetProperty)new SrcGetProperty(propName, type1).modifiers(0x80000000000L)).body("return (" + propertyType + ")" + RuntimeMethods.class.getSimpleName() + ".coerce(getBindings().get(\"" + name + "\"), " + componentType + ".class);");
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
            this.addSourcePositionAnnotation(srcClass, (Node)field, name, (SrcAnnotated)getter);
            ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
            String identifier = SrcLinkedClass.makeIdentifier((String)name, (boolean)false);
            String fqn = srcClass.getName() + '.' + identifier;
            SrcLinkedClass srcInnerResult = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)srcClass, AbstractSrcClass.Kind.Interface).addInterface(IJsonBindingsBacked.class.getSimpleName())).addAnnotation(new SrcAnnotationExpression(Structural.class.getSimpleName()).addArgument("factoryClass", Class.class, (Object)(identifier + ".ProxyFactory.class")))).modifiers(1L);
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcInnerResult, (String)name, (boolean)false);
            this.addSourcePositionAnnotation(srcClass, (Node)field, name, (SrcAnnotated)srcInnerResult);
            this.addProxyFactory(srcInnerResult);
            for (Selection member : childSelections.getSelections()) {
                TypeDefinition typeDef = this.findTypeDefinition(type);
                if (typeDef == null) continue;
                this.addQuerySelection(srcInnerResult, typeDef, member);
            }
            srcClass.addInnerClass((AbstractSrcClass)srcInnerResult);
        }
    }

    private TypeDefinition findTypeDefinition(Type type) {
        TypeName componentType = (TypeName)this.getComponentType(type);
        TypeDefinition typeDefinition = this._registry.getType((Type)componentType).orElse(null);
        if (typeDefinition != null) {
            return typeDefinition;
        }
        return this._gqlManifold.findTypeDefinition(componentType.getName());
    }

    private ScalarTypeDefinition findScalarTypeDefinition(TypeName type) {
        TypeName componentType = (TypeName)this.getComponentType((Type)type);
        ScalarTypeDefinition typeDefinition = (ScalarTypeDefinition)this._registry.scalars().get(componentType.getName());
        if (typeDefinition != null) {
            return typeDefinition;
        }
        return this._gqlManifold.findScalarTypeDefinition(componentType.getName());
    }

    private SchemaDefinition findSchemaDefinition() {
        if (this._schemaDefinition != null) {
            return this._schemaDefinition;
        }
        return this._gqlManifold.findSchemaDefinition();
    }

    private void addMember(SrcLinkedClass srcClass, FieldDefinition member, Predicate<String> duplicateChecker) {
        Type type = member.getType();
        String name = SrcLinkedClass.makeIdentifier((String)member.getName(), (boolean)false);
        this.addMember(srcClass, (NamedNode)member, type, name, duplicateChecker);
    }

    private void addMember(SrcLinkedClass srcClass, InputValueDefinition member, Predicate<String> duplicateChecker) {
        Type type = member.getType();
        String name = SrcLinkedClass.makeIdentifier((String)member.getName(), (boolean)false);
        this.addMember(srcClass, (NamedNode)member, type, name, duplicateChecker);
    }

    private void addMember(SrcLinkedClass srcClass, NamedNode member, Type type, String name, Predicate<String> duplicateChecker) {
        SrcType srcType = this.makeSrcType(type, false);
        String propName = SrcLinkedClass.makeIdentifier((String)name, (boolean)true);
        if (!propName.equals(name) && duplicateChecker.test(propName)) {
            propName = '_' + SrcLinkedClass.makeIdentifier((String)name, (boolean)false);
        }
        StringBuilder propertyType = srcType.render(new StringBuilder(), 0, false);
        StringBuilder componentType = this.getComponentType(srcType).render(new StringBuilder(), 0, false);
        SrcGetProperty getter = (SrcGetProperty)((SrcGetProperty)new SrcGetProperty(propName, srcType).modifiers(0x80000000000L)).body("return (" + propertyType + ")" + RuntimeMethods.class.getSimpleName() + ".coerce(getBindings().get(\"" + name + "\"), " + componentType + ".class);");
        if (member != null) {
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
            this.addSourcePositionAnnotation(srcClass, (Node)member, name, (SrcAnnotated)getter);
        }
        ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
        SrcSetProperty setter = (SrcSetProperty)((SrcSetProperty)new SrcSetProperty(propName, srcType).modifiers(0x80000000000L)).body("getBindings().put(\"" + name + "\", " + RuntimeMethods.class.getSimpleName() + ".coerceToBindingValue($value));\n");
        if (member != null) {
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)setter, (String)name, (boolean)true);
            this.addSourcePositionAnnotation(srcClass, (Node)member, name, (SrcAnnotated)setter);
        }
        ((SrcLinkedClass)srcClass.addSetProperty(setter)).modifiers(1L);
    }

    private String findLub(UnionTypeDefinition typeDef) {
        HashSet<Set<Object>> ifaces = new HashSet<Set<Object>>();
        for (Type t : typeDef.getMemberTypes()) {
            TypeDefinition td = this.findTypeDefinition(t);
            if (td instanceof ObjectTypeDefinition) {
                ifaces.add(((ObjectTypeDefinition)td).getImplements().stream().map(type -> (InterfaceTypeDefinition)this.findTypeDefinition((Type)type)).collect(Collectors.toSet()));
                continue;
            }
            if (!(td instanceof InterfaceTypeDefinition)) continue;
            ifaces.add(Collections.singleton((InterfaceTypeDefinition)td));
        }
        Set intersection = (Set)ifaces.stream().reduce((p1, p2) -> {
            p1.retainAll((Collection<?>)p2);
            return p1;
        }).get();
        if (intersection.isEmpty()) {
            return null;
        }
        return ((InterfaceTypeDefinition)intersection.iterator().next()).getName();
    }

    private ListType getListType(Type type) {
        if (type instanceof ListType) {
            return (ListType)type;
        }
        if (type instanceof TypeName) {
            return null;
        }
        return this.getListType(((NonNullType)type).getType());
    }

    private SrcType getComponentType(SrcType type) {
        List typeParams = type.getTypeParams();
        if (!typeParams.isEmpty()) {
            return this.getComponentType((SrcType)typeParams.get(0));
        }
        return type;
    }

    private void addSourcePositionAnnotation(SrcLinkedClass srcClass, NamedNode node, SrcAnnotated srcAnno) {
        this.addSourcePositionAnnotation(srcClass, (Node)node, () -> ((NamedNode)node).getName(), srcAnno);
    }

    private void addSourcePositionAnnotation(SrcLinkedClass srcClass, Node node, Supplier<String> name, SrcAnnotated srcAnno) {
        this.addSourcePositionAnnotation(srcClass, node, name.get(), srcAnno);
    }

    private SourceLocation getActualSourceLocation(SrcLinkedClass srcClass, Node node) {
        String startSymbol = this.getStartSymbol(node);
        SourceLocation loc = node.getSourceLocation();
        if (GRAPHQL_LINE_OFFSET_BUG == null && (GRAPHQL_LINE_OFFSET_BUG = Boolean.valueOf(!srcClass.verifyOffset(loc.getLine(), loc.getColumn(), startSymbol))).booleanValue() && !srcClass.verifyOffset(loc.getLine() - 1, loc.getColumn(), startSymbol)) {
            GRAPHQL_LINE_OFFSET_BUG = null;
            System.out.println("GRAPHQL_LINE_OFFSET_BUG check failure");
            return loc;
        }
        int line = loc.getLine();
        if (GRAPHQL_LINE_OFFSET_BUG.booleanValue()) {
            --line;
        }
        int columnOffset = startSymbol.isEmpty() ? 0 : startSymbol.length() + 1;
        int column = loc.getColumn() + columnOffset;
        return new SourceLocation(line, column);
    }

    private void addSourcePositionAnnotation(SrcLinkedClass srcClass, Node node, String name, SrcAnnotated srcAnno) {
        SourceLocation loc = this.getActualSourceLocation(srcClass, node);
        srcClass.addSourcePositionAnnotation(srcAnno, name, loc.getLine(), loc.getColumn());
    }

    private String getStartSymbol(Node node) {
        String start = "";
        if (node instanceof TypeDefinition) {
            if (node instanceof ObjectTypeDefinition) {
                start = "type";
            } else if (node instanceof EnumTypeDefinition) {
                start = "enum";
            } else if (node instanceof InputObjectTypeDefinition) {
                start = "input";
            } else if (node instanceof InterfaceTypeDefinition) {
                start = "interface";
            } else if (node instanceof ScalarTypeDefinition) {
                start = "scalar";
            } else if (node instanceof UnionTypeDefinition) {
                start = "union";
            }
        } else if (node instanceof OperationDefinition) {
            start = ((OperationDefinition)node).getOperation().name().toLowerCase();
        }
        return start;
    }

    private Type getComponentType(Type type) {
        if (type instanceof ListType) {
            return this.getComponentType(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return this.getComponentType(((NonNullType)type).getType());
        }
        return type;
    }

    private String convertType(Type type, String component) {
        ListType listType = this.getListType(type);
        if (listType != null) {
            return List.class.getSimpleName() + '<' + this.convertType(listType.getType(), component) + '>';
        }
        return component;
    }

    private SrcType convertSrcType(Type type, String component) {
        SrcType srcType = new SrcType(this.convertType(type, component));
        if (type instanceof NonNullType) {
            srcType.addAnnotation(new SrcAnnotationExpression(NotNull.class.getSimpleName()));
        }
        return srcType;
    }

    private SrcType makeSrcType(Type type, boolean typeParam) {
        SrcType srcType;
        if (type instanceof ListType) {
            srcType = new SrcType("List");
            srcType.addTypeParam(this.makeSrcType(((ListType)type).getType(), true));
        } else if (type instanceof TypeName) {
            String typeName = this.getJavaClassName((TypeName)type, typeParam);
            srcType = new SrcType(typeName);
            if (!typeParam) {
                Class<?> javaClass = this.getJavaClass((TypeName)type, false);
                srcType.setPrimitive(javaClass != null && javaClass.isPrimitive());
            }
        } else if (type instanceof NonNullType) {
            Type theType = ((NonNullType)type).getType();
            srcType = this.makeSrcType(theType, typeParam);
            if (!typeParam && !srcType.isPrimitive()) {
                srcType.addAnnotation(new SrcAnnotationExpression(NotNull.class.getSimpleName()));
            }
        } else {
            throw new IllegalStateException("Unhandled type: " + type.getClass().getTypeName());
        }
        return srcType;
    }

    private String getJavaClassName(TypeName type, boolean boxed) {
        ScalarTypeDefinition scalarType = this.findScalarTypeDefinition(type);
        if (scalarType == null) {
            return SrcLinkedClass.makeIdentifier((String)type.getName(), (boolean)false);
        }
        Class<?> cls = this.getJavaClass(type, boxed);
        return cls == null ? scalarType.getName() : this.getJavaName(cls);
    }

    @NotNull
    private String getJavaName(Class<?> cls) {
        if (cls == String.class) {
            return String.class.getSimpleName();
        }
        return cls.getTypeName();
    }

    @Nullable
    private Class<?> getJavaClass(TypeName type, boolean boxed) {
        Class cls;
        switch (type.getName()) {
            case "String": 
            case "ID": {
                cls = String.class;
                break;
            }
            case "Byte": {
                cls = boxed ? Byte.class : Byte.TYPE;
                break;
            }
            case "Char": 
            case "Character": {
                cls = boxed ? Character.class : Character.TYPE;
                break;
            }
            case "Int": 
            case "Integer": {
                cls = boxed ? Integer.class : Integer.TYPE;
                break;
            }
            case "Long": {
                cls = boxed ? Long.class : Long.TYPE;
                break;
            }
            case "Float": 
            case "Double": {
                cls = boxed ? Double.class : Double.TYPE;
                break;
            }
            case "Boolean": {
                cls = boxed ? Boolean.class : Boolean.TYPE;
                break;
            }
            case "BigInteger": {
                cls = BigInteger.class;
                break;
            }
            case "BigDecimal": {
                cls = BigDecimal.class;
                break;
            }
            default: {
                cls = this.findFormatType(type.getName());
            }
        }
        return cls;
    }

    private Class<?> findFormatType(String scalarName) {
        for (IJsonFormatTypeResolver resolver : Objects.requireNonNull(FormatTypeResolvers.get())) {
            JsonFormatType resolvedType = resolver.resolveType(scalarName);
            if (resolvedType == null) continue;
            return resolvedType.getJavaType();
        }
        return this.findJsonEquivalent(scalarName);
    }

    private Class<?> findJsonEquivalent(String scalarName) {
        switch (scalarName) {
            case "Time": 
            case "LocalTime": {
                return this.findFormatType("time");
            }
            case "Date": 
            case "LocalDate": {
                return this.findFormatType("date");
            }
            case "DateTime": 
            case "LocalDateTime": {
                return this.findFormatType("date-time");
            }
            case "Instant": {
                return this.findFormatType("utc-millisec");
            }
            case "Base64": {
                return this.findFormatType("binary");
            }
            case "Binary": 
            case "Octet": {
                return this.findFormatType("byte");
            }
        }
        return String.class;
    }
}

