/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.lang.model.type.NoType;
import manifold.api.host.IModule;
import manifold.ext.DynamicTypeProxyGenerator;
import manifold.ext.StructuralTypeProxyGenerator;
import manifold.ext.rt.api.ICallHandler;
import manifold.ext.rt.api.IDynamicProxyFactory;
import manifold.ext.rt.api.IProxyFactory;
import manifold.internal.host.RuntimeManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.rt.api.util.Pair;
import manifold.util.ManExceptionUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class DynamicProxyFactory
implements IDynamicProxyFactory {
    private static final String STRUCTURAL_PROXY = "_structuralproxy_";
    private static final Map<Class, Boolean> ICALL_HANDLER_MAP = new ConcurrentWeakHashMap();

    public IProxyFactory makeProxyFactory(Class iface, Class rootClass) {
        String relativeProxyName = rootClass.getCanonicalName().replace('.', '_') + STRUCTURAL_PROXY + iface.getCanonicalName().replace('.', '_');
        Class proxyClass = DynamicProxyFactory.hasCallHandlerMethod(rootClass) ? DynamicTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName) : StructuralTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
        Constructor<?> constructor = proxyClass.getConstructors()[0];
        ReflectUtil.setAccessible(constructor);
        return new Factory(constructor);
    }

    private static boolean hasCallHandlerMethod(Class rootClass) {
        if (ICallHandler.class.isAssignableFrom(rootClass)) {
            return true;
        }
        if (ReflectUtil.method((Class)rootClass, (String)"call", (Class[])new Class[]{Class.class, String.class, String.class, Class.class, Class[].class, Object[].class}) != null) {
            return true;
        }
        return DynamicProxyFactory.hasCallHandlerFromExtension(rootClass);
    }

    private static boolean hasCallHandlerFromExtension(Class rootClass) {
        Boolean isCallHandler = ICALL_HANDLER_MAP.get(rootClass);
        if (isCallHandler != null) {
            return isCallHandler;
        }
        String fqn = rootClass.getCanonicalName();
        BasicJavacTask javacTask = RuntimeManifoldHost.get().getJavaParser().getJavacTask();
        Pair classSymbol = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule()).getClassSymbol(javacTask, fqn);
        Pair callHandlerSymbol = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule()).getClassSymbol(javacTask, ICallHandler.class.getCanonicalName());
        isCallHandler = Types.instance(javacTask.getContext()).isAssignable((Type)((Symbol.ClassSymbol)classSymbol.getFirst()).asType(), (Type)((Symbol.ClassSymbol)callHandlerSymbol.getFirst()).asType()) ? Boolean.valueOf(true) : Boolean.valueOf(DynamicProxyFactory.hasCallMethod(javacTask, (Symbol.ClassSymbol)classSymbol.getFirst()));
        ICALL_HANDLER_MAP.put(rootClass, isCallHandler);
        return isCallHandler;
    }

    private static boolean hasCallMethod(BasicJavacTask javacTask, Symbol.ClassSymbol classSymbol) {
        Name call = Names.instance(javacTask.getContext()).fromString("call");
        Iterable elems = IDynamicJdk.instance().getMembersByName(classSymbol, call);
        for (Symbol s : elems) {
            if (!(s instanceof Symbol.MethodSymbol)) continue;
            java.util.List parameters = ((Symbol.MethodSymbol)s).getParameters();
            if (((List)parameters).size() != 6) {
                return false;
            }
            Symtab symbols = Symtab.instance(javacTask.getContext());
            Types types = Types.instance(javacTask.getContext());
            return types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(0)).asType()).equals(types.erasure(symbols.classType)) && ((Type)((Symbol.VarSymbol)((List)parameters).get(1)).asType()).equals(symbols.stringType) && ((Type)((Symbol.VarSymbol)((List)parameters).get(2)).asType()).equals(symbols.stringType) && types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(3)).asType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(4)).asType() instanceof Type.ArrayType && types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(4)).asType()).getComponentType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(5)).asType() instanceof Type.ArrayType && ((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(5)).asType()).getComponentType().equals(symbols.objectType);
        }
        Type superclass = classSymbol.getSuperclass();
        if (!(superclass instanceof NoType) && DynamicProxyFactory.hasCallMethod(javacTask, (Symbol.ClassSymbol)superclass.tsym)) {
            return true;
        }
        for (Type iface : classSymbol.getInterfaces()) {
            if (!DynamicProxyFactory.hasCallMethod(javacTask, (Symbol.ClassSymbol)iface.tsym)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    implements IProxyFactory {
        private final Constructor _constructor;

        public Factory(Constructor constructor) {
            this._constructor = constructor;
        }

        public Object proxy(Object target, Class iface) {
            try {
                return this._constructor.newInstance(target);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked((Throwable)e);
            }
        }
    }
}

