/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.util.Objects;

@FunctionalInterface
public interface IndexedFunction<T, R> {
    public R apply(int var1, T var2);

    default public <V> IndexedFunction<V, R> compose(IndexedFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return (index, v) -> this.apply(index, before.apply(index, (Object)v));
    }

    default public <V> IndexedFunction<T, V> andThen(IndexedFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (index, t) -> after.apply(index, (R)this.apply(index, t));
    }

    public static <T> IndexedFunction<T, T> identity() {
        return (i, t) -> t;
    }
}

