/*
 * Decompiled with CFR 0.152.
 */
package manifold.test.api;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import junit.framework.TestCase;
import manifold.internal.runtime.Bootstrap;

public abstract class ExtensionManifoldTest
extends TestCase {
    public abstract void testCoverage();

    protected void testCoverage(Class extensionClass) {
        Method[] methods = extensionClass.getMethods();
        ArrayList<String> untested = new ArrayList<String>();
        for (Method m : methods) {
            if (!Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers())) continue;
            try {
                String name = m.getName();
                ((Object)((Object)this)).getClass().getMethod("test" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]);
            }
            catch (Exception e2) {
                String fullDesc = m.toString();
                untested.add("Untested: " + fullDesc.substring(fullDesc.indexOf('.' + m.getName() + '(') + 1));
            }
        }
        if (!untested.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            untested.stream().sorted().forEach(e -> msg.append((String)e).append("\n"));
            msg.append("Expecting at least one test method per extension method of the form: testXxx().\n");
            TestCase.fail((String)msg.toString());
        }
    }

    static {
        Bootstrap.init();
    }
}

