/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.rt.api;

import manifold.ext.rt.api.Structural;

@Structural
public interface ComparableUsing<T>
extends Comparable<T> {
    default public boolean compareToUsing(T that, Operator op) {
        switch (op) {
            case LT: {
                return this.compareTo(that) < 0;
            }
            case LE: {
                return this.compareTo(that) <= 0;
            }
            case GT: {
                return this.compareTo(that) > 0;
            }
            case GE: {
                return this.compareTo(that) >= 0;
            }
            case EQ: {
                switch (this.equalityMode()) {
                    case CompareTo: {
                        return this.compareTo(that) == 0;
                    }
                    case Equals: {
                        return this.equals(that);
                    }
                    case Identity: {
                        return this == that;
                    }
                }
            }
            case NE: {
                switch (this.equalityMode()) {
                    case CompareTo: {
                        return this.compareTo(that) != 0;
                    }
                    case Equals: {
                        return !this.equals(that);
                    }
                    case Identity: {
                        return this != that;
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    default public EqualityMode equalityMode() {
        return EqualityMode.Equals;
    }

    public static enum EqualityMode {
        CompareTo,
        Equals,
        Identity;

    }

    public static enum Operator {
        GT,
        GE,
        LT,
        LE,
        EQ,
        NE;

    }
}

