/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.producer.sample;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcReturnStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.api.type.IModel;
import manifold.ext.producer.sample.FavsParser;
import manifold.ext.producer.sample.Token;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import manifold.rt.api.SourcePosition;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.StreamUtil;

public class Model
implements IModel {
    private static final String FAVS_EXTENSIONS = "favs.extensions.";
    private static final String FIELD_FILE_URL = "_FILE_URL_";
    private final String _extensionFqn;
    private final Set<IFile> _favsFiles;
    private final IManifoldHost _host;

    Model(IManifoldHost host, String extensionFqn, Set<IFile> favsFiles) {
        this._host = host;
        this._extensionFqn = extensionFqn;
        this._favsFiles = new HashSet<IFile>(favsFiles);
    }

    public IManifoldHost getHost() {
        return this._host;
    }

    public String getFqn() {
        return this._extensionFqn;
    }

    public Set<IFile> getFiles() {
        return this._favsFiles;
    }

    public void addFile(IFile file) {
        this._favsFiles.add(file);
    }

    public void removeFile(IFile file) {
        this._favsFiles.remove(file);
    }

    public void updateFile(IFile file) {
        this._favsFiles.remove(file);
        this._favsFiles.add(file);
    }

    static Set<String> getExtendedTypes(IFile file) {
        String content;
        Objects.requireNonNull(file);
        try {
            content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> extendedTypes = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(content, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            StringTokenizer lineTokenizer = new StringTokenizer(line, "|");
            String extended = lineTokenizer.nextToken();
            extendedTypes.add(extended);
        }
        return extendedTypes;
    }

    static String makeExtensionClassName(String extendedClassname) {
        String simpleName = ManClassUtil.getShortClassName((String)extendedClassname);
        return FAVS_EXTENSIONS + extendedClassname + ".My" + simpleName + "Ext";
    }

    static String deriveExtendedClassFrom(String extensionClassName) {
        if (extensionClassName.startsWith(FAVS_EXTENSIONS)) {
            String extended = extensionClassName.substring(FAVS_EXTENSIONS.length());
            int iDot = extended.lastIndexOf(46);
            return extended.substring(0, iDot);
        }
        return null;
    }

    String makeSource(String extensionClassFqn, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcClass = (SrcClass)((SrcClass)new SrcClass(extensionClassFqn, AbstractSrcClass.Kind.Class, location, module, errorHandler).addAnnotation(new SrcAnnotationExpression(Extension.class))).modifiers(1L);
        int i = 0;
        for (IFile iFile : this._favsFiles) {
            srcClass.addField((SrcField)new SrcField(FIELD_FILE_URL + i++, String.class).initializer((SrcExpression)new SrcRawExpression(String.class, (Object)iFile.getPath().getFileSystemPathString())).modifiers(24L));
        }
        for (Map.Entry entry : FavsParser.instance().parseFavsForType(this._favsFiles, this._extensionFqn, errorHandler).entrySet()) {
            SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(9L)).name("favorite" + entry.getKey())).addParam((SrcParameter)new SrcParameter("thiz", Model.deriveExtendedClassFrom(extensionClassFqn)).addAnnotation(new SrcAnnotationExpression(This.class)))).returns(String.class)).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcReturnStatement(String.class, (Object)((Token)entry.getValue())._value.toString())));
            method.addAnnotation(this.makeSourcePositionAnnotation((Token)entry.getKey()));
            srcClass.addMethod((AbstractSrcMethod)method);
        }
        return srcClass.render().toString();
    }

    private SrcAnnotationExpression makeSourcePositionAnnotation(Token token) {
        int i = this.getFileIndex(token);
        return new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{ManClassUtil.getShortClassName((String)this._extensionFqn), FIELD_FILE_URL + i})).name("url")).addArgument("feature", String.class, (Object)token._value.toString()).addArgument("kind", String.class, (Object)"favorite").addArgument("offset", Integer.TYPE, (Object)token._pos).addArgument("length", Integer.TYPE, (Object)token._value.length());
    }

    private int getFileIndex(Token token) {
        int i = 0;
        for (IFile file : this._favsFiles) {
            if (file.equals(token._file)) break;
            ++i;
        }
        return i;
    }
}

