/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.producer.sample;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.ext.producer.sample.Model;
import manifold.ext.producer.sample.Token;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.util.JavacDiagnostic;
import manifold.util.StreamUtil;

class FavsParser {
    private static final FavsParser INSTANCE = new FavsParser();

    FavsParser() {
    }

    static FavsParser instance() {
        return INSTANCE;
    }

    Map<Token, Token> parseFavsForType(Set<IFile> files, String extensionClassFqn, DiagnosticListener<JavaFileObject> errorHandler) {
        LinkedHashMap<Token, Token> mapFavToValue = new LinkedHashMap<Token, Token>();
        for (IFile file : files) {
            Objects.requireNonNull(file);
            List<List<Token>> rows = this.tokenize(file);
            Token token = null;
            for (List<Token> line : rows) {
                Iterator<Token> tokens = line.iterator();
                if (!tokens.hasNext()) {
                    errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(this.makeJavaObjectFile(file), Diagnostic.Kind.ERROR, token == null ? 0L : (long)token._pos, 0L, 0L, "Expecting a qualified type name"));
                    continue;
                }
                token = tokens.next();
                Token fqn = token;
                String extensionFqn = Model.makeExtensionClassName(fqn.toString());
                if (!extensionFqn.equals(extensionClassFqn)) continue;
                if (!tokens.hasNext()) {
                    errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(this.makeJavaObjectFile(file), Diagnostic.Kind.ERROR, (long)(fqn._pos + fqn._value.length() - 1), 0L, 0L, "Expecting a 'favorite' name"));
                    continue;
                }
                Token fav = token = tokens.next();
                if (!tokens.hasNext()) {
                    errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(this.makeJavaObjectFile(file), Diagnostic.Kind.ERROR, (long)(fav._pos + fav._value.length() - 1), 0L, 0L, "Expecting a value for '" + fav._value + "'"));
                    continue;
                }
                Token value = token = tokens.next();
                mapFavToValue.put(fav, value);
            }
        }
        return mapFavToValue;
    }

    private List<List<Token>> tokenize(IFile file) {
        String content;
        try {
            content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<List<Token>> rows = new ArrayList<List<Token>>();
        ArrayList<Token> row = null;
        Token token = null;
        for (int pos = 0; pos <= content.length(); ++pos) {
            char c;
            char c2 = c = pos == content.length() ? (char)'\u0000' : content.charAt(pos);
            if (c == '|' || c == '\n' || c == '\u0000') {
                if (token == null) break;
                row = row == null ? new ArrayList<Token>() : row;
                row.add(token);
                token = null;
                if (c != '\n' && c != '\u0000') continue;
                rows.add(row);
                row = null;
                continue;
            }
            if (c == '\r') continue;
            token = token == null ? new Token(pos, file) : token;
            token.append(c);
        }
        return rows;
    }

    private JavaFileObject makeJavaObjectFile(IFile file) {
        SourceJavaFileObject jfo;
        try {
            jfo = new SourceJavaFileObject(file.toURI());
        }
        catch (Exception e) {
            jfo = null;
        }
        return jfo;
    }
}

