/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.delegation.rt;

import java.util.Arrays;
import java.util.Set;
import manifold.ext.delegation.rt.api.link;
import manifold.rt.api.util.ManClassUtil;
import manifold.util.ReflectUtil;

public class RuntimeMethods {
    public static final String SELF_FIELD = "$theSelf";
    public static final String COVERED_FIELD = "$interfacesFullyCovered";

    public static Object linkPart(Object delegatingClass, String fieldName, Object part2) {
        if (part2 == null) {
            throw new IllegalStateException("Part class instance is null for field `" + fieldName + "'");
        }
        if (delegatingClass == null) {
            throw new IllegalStateException("Delegating class instance is null when assigned to field '" + fieldName + "' of part class '" + part2.getClass().getTypeName());
        }
        RuntimeMethods.linkPartToSelf(delegatingClass, part2);
        return part2;
    }

    private static void linkPartToSelf(Object delegatingClass, Object part2) {
        ReflectUtil.LiveFieldRef self = ReflectUtil.WithNull.field((Object)part2, (String)SELF_FIELD);
        if (self == null) {
            return;
        }
        if (RuntimeMethods.areAllPartInterfacesLinked(delegatingClass, part2)) {
            ReflectUtil.LiveFieldRef covered = ReflectUtil.WithNull.field((Object)part2, (String)COVERED_FIELD);
            if (covered == null) {
                return;
            }
            covered.set((Object)true);
        }
        self.set(delegatingClass);
        for (Class<?> superclass = part2.getClass().getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            ReflectUtil.field(superclass, (String)SELF_FIELD).set(part2, delegatingClass);
        }
        ReflectUtil.fields((Object)part2, f -> !f.isStatic() && f.getField().getAnnotation(link.class) != null).forEach(delegateField -> {
            Object partDelegate = delegateField.get();
            RuntimeMethods.linkPartToSelf(delegatingClass, partDelegate);
        });
    }

    private static boolean areAllPartInterfacesLinked(Object delegatingClass, Object part2) {
        Set partInterfaces = ManClassUtil.getAllInterfaces(part2.getClass());
        int partInterfaceCount = partInterfaces.size();
        partInterfaces.retainAll(ManClassUtil.getAllInterfaces(delegatingClass.getClass()));
        return partInterfaces.size() == partInterfaceCount;
    }

    public static Object invokeDefault(Object receiver, Class iface, String name, Object paramsArray, Object argsArray) {
        return ReflectUtil.invokeDefault((Object)receiver, (Class)iface, (String)name, (Class[])((Class[])paramsArray), (Object[])((Object[])argsArray));
    }

    public static Object replaceThis(Class<?> iface, Object self, Object this_) {
        if (iface == null) {
            throw new IllegalArgumentException("Interface class is null");
        }
        if (!iface.isInterface()) {
            throw new IllegalStateException("Expecting an interface type");
        }
        if (self == null) {
            return this_;
        }
        return RuntimeMethods.linksInterfaceTo(iface, self, this_) ? self : this_;
    }

    public static boolean linksInterfaceTo(Class<?> iface, Object from, Object to) {
        if (((Boolean)ReflectUtil.field((Object)to, (String)COVERED_FIELD).get()).booleanValue()) {
            return true;
        }
        return RuntimeMethods._linksInterfaceTo(iface, from, to);
    }

    private static boolean _linksInterfaceTo(Class<?> iface, Object from, Object to) {
        if (from == null) {
            return false;
        }
        for (ReflectUtil.LiveFieldRef f2 : ReflectUtil.fields((Object)from, f -> !f.isStatic())) {
            Class<?> type;
            Class<?>[] annoTypes;
            Object value;
            link linkAnno = f2.getField().getAnnotation(link.class);
            if (linkAnno == null || !iface.isInstance(value = f2.get()) || !((annoTypes = linkAnno.value()) != null && annoTypes.length > 0 ? Arrays.stream(annoTypes).anyMatch(t -> iface.isAssignableFrom((Class<?>)t)) && (value == to || RuntimeMethods.linksInterfaceTo(iface, value, to)) : iface.isAssignableFrom(type = f2.getField().getType()) && (value == to || RuntimeMethods.linksInterfaceTo(iface, value, to)))) continue;
            return true;
        }
        return false;
    }
}

