/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class BootstrapPlugin
implements Plugin,
TaskListener {
    private Context _ctx;
    private boolean _done;

    @Override
    public String getName() {
        return "BootstrapPlugin";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        this._ctx = ((BasicJavacTask)task).getContext();
        task.addTaskListener(this);
    }

    @Override
    public void started(TaskEvent te) {
        if (JreUtil.isJava8()) {
            return;
        }
        CompilationUnitTree compilationUnit = te.getCompilationUnit();
        if (!(compilationUnit instanceof JCTree.JCCompilationUnit)) {
            return;
        }
        if (this._done) {
            return;
        }
        this._done = true;
        BootstrapPlugin.openModule(this._ctx, "jdk.compiler");
    }

    @Override
    public void finished(TaskEvent e) {
    }

    public static void openModule(Context context, String moduleName) {
        try {
            Symbol moduleToOpen = (Symbol)ReflectUtil.method((Object)Symtab.instance(context), (String)"getModule", (Class[])new Class[]{Name.class}).invoke(new Object[]{Names.instance(context).fromString(moduleName)});
            if (moduleToOpen == null) {
                return;
            }
            moduleToOpen.complete();
            Set rootModules = (Set)ReflectUtil.field((Object)ReflectUtil.method((Class)ReflectUtil.type((String)"com.sun.tools.javac.comp.Modules"), (String)"instance", (Class[])new Class[]{Context.class}).invokeStatic(new Object[]{context}), (String)"allModules").get();
            for (Symbol rootModule : rootModules) {
                rootModule.complete();
                List requires = (List)ReflectUtil.field((Object)rootModule, (String)"requires").get();
                ArrayList<Object> newRequires = new ArrayList<Object>(requires);
                Object addedRequires = ReflectUtil.constructor((String)"com.sun.tools.javac.code.Directive$RequiresDirective", (Class[])new Class[]{ReflectUtil.type((String)"com.sun.tools.javac.code.Symbol$ModuleSymbol")}).newInstance(new Object[]{moduleToOpen});
                newRequires.add(addedRequires);
                requires = List.from(newRequires);
                ReflectUtil.field((Object)rootModule, (String)"requires").set(requires);
                ArrayList<Object> exports = new ArrayList<Object>((Collection)ReflectUtil.field((Object)moduleToOpen, (String)"exports").get());
                for (Symbol pkg : (Iterable)ReflectUtil.field((Object)moduleToOpen, (String)"enclosedPackages").get()) {
                    if (!(pkg instanceof Symbol.PackageSymbol)) continue;
                    Object exp = ReflectUtil.constructor((String)"com.sun.tools.javac.code.Directive$ExportsDirective", (Class[])new Class[]{Symbol.PackageSymbol.class, List.class}).newInstance(new Object[]{pkg, List.of(rootModule)});
                    exports.add(exp);
                    ((Map)ReflectUtil.field((Object)rootModule, (String)"visiblePackages").get()).put(((Symbol.PackageSymbol)pkg).fullname, pkg);
                }
                ReflectUtil.field((Object)moduleToOpen, (String)"exports").set(List.from(exports));
                Set readModules = (Set)ReflectUtil.field((Object)moduleToOpen, (String)"readModules").get();
                readModules.add(rootModule);
                ReflectUtil.field((Object)moduleToOpen, (String)"readModules").set((Object)readModules);
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to reflectively add-exports " + moduleName + "/* to root module[s], you must add the following argument to jave.exe:\n  --add-exports=" + moduleName + "/*=<root-module>\n");
            throw new RuntimeException(e);
        }
    }
}

