/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra;

import com.codahale.metrics.health.HealthCheck;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import io.dropwizard.util.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHealthCheck
extends HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraHealthCheck.class);
    private final Session session;
    private final String validationQuery;
    private final Duration timeout;

    public CassandraHealthCheck(Cluster cluster, String validationQuery, Duration timeout) {
        this.session = cluster.connect();
        this.validationQuery = validationQuery;
        this.timeout = timeout;
    }

    protected HealthCheck.Result check() throws Exception {
        try {
            this.session.executeAsync(this.validationQuery).get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            return HealthCheck.Result.healthy();
        }
        catch (Exception ex) {
            LOG.error("Unable to connect to Cassandra cluster [{}]", (Object)this.session.getCluster().getClusterName(), (Object)ex);
            throw ex;
        }
    }
}

