/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.workflow.osworkflow.configuration;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.config.DefaultConfiguration;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.xml.sax.SAXException;

public class ConfigurationBean
extends DefaultConfiguration {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$workflow$osworkflow$configuration$ConfigurationBean == null ? (class$org$springmodules$workflow$osworkflow$configuration$ConfigurationBean = ConfigurationBean.class$("org.springmodules.workflow.osworkflow.configuration.ConfigurationBean")) : class$org$springmodules$workflow$osworkflow$configuration$ConfigurationBean));
    protected ResourceLoader resourceLoader = new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
    private Map persistenceArgs = new HashMap();
    private Map workflows = new HashMap();
    static /* synthetic */ Class class$org$springmodules$workflow$osworkflow$configuration$ConfigurationBean;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$memory$MemoryWorkflowStore;

    public ConfigurationBean() {
        this.setPersistence((class$com$opensymphony$workflow$spi$memory$MemoryWorkflowStore == null ? (class$com$opensymphony$workflow$spi$memory$MemoryWorkflowStore = ConfigurationBean.class$("com.opensymphony.workflow.spi.memory.MemoryWorkflowStore")) : class$com$opensymphony$workflow$spi$memory$MemoryWorkflowStore).getName());
    }

    public Map getPersistenceArgs() {
        return this.persistenceArgs;
    }

    public void setPersistenceArgs(Map persistenceArgs) {
        Assert.notEmpty((Map)persistenceArgs, (String)"persistenceArgs cannot be null or empty");
        this.persistenceArgs = persistenceArgs;
    }

    public void setWorkflowLocations(Properties workflowLocations) {
        Assert.notNull((Object)workflowLocations, (String)"workflowLocations cannot be null");
        Enumeration<?> workflowNames = workflowLocations.propertyNames();
        while (workflowNames.hasMoreElements()) {
            String name = (String)workflowNames.nextElement();
            String resourceLocation = workflowLocations.getProperty(name);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Loading workflow [" + name + "] from [" + resourceLocation + "]."));
            }
            this.workflows.put(name, this.loadWorkflowDescriptor(resourceLocation, name));
        }
    }

    public WorkflowDescriptor getWorkflow(String name) throws FactoryException {
        WorkflowDescriptor wd = (WorkflowDescriptor)this.workflows.get(name);
        if (wd == null) {
            throw new FactoryException("Unknown workflow name [" + name + "].");
        }
        return wd;
    }

    public String[] getWorkflowNames() throws FactoryException {
        Set names = this.workflows.keySet();
        return names.toArray(new String[names.size()]);
    }

    public boolean removeWorkflow(String string) throws FactoryException {
        throw new UnsupportedOperationException("Operation removeWorkflow(String) not supported.");
    }

    protected WorkflowDescriptor loadWorkflowDescriptor(String resourceLocation, String name) {
        Resource resource = this.resourceLoader.getResource(resourceLocation);
        WorkflowDescriptor workflowDescriptor = null;
        try {
            workflowDescriptor = WorkflowLoader.load((URL)resource.getURL());
        }
        catch (IOException ex) {
            throw new FatalBeanException("Unable to load workflow resource [" + resourceLocation + "].", (Throwable)ex);
        }
        catch (InvalidWorkflowDescriptorException ex) {
            throw new FatalBeanException("Descriptor for workflow [" + name + "] in [" + resourceLocation + "] is invalid.", (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new FatalBeanException("XML in descriptorfor workflow [" + name + "] in [" + resourceLocation + "] is invalid.", (Throwable)ex);
        }
        return workflowDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

