/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jsr94.core;

import java.rmi.RemoteException;
import java.util.Map;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleSession;
import javax.rules.RuleSessionCreateException;
import javax.rules.RuleSessionTypeUnsupportedException;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springmodules.jsr94.Jsr94InvalidHandleException;
import org.springmodules.jsr94.Jsr94InvalidRuleSessionException;
import org.springmodules.jsr94.Jsr94RemoteException;
import org.springmodules.jsr94.Jsr94RuleExecutionSetNotFoundException;
import org.springmodules.jsr94.Jsr94RuleSessionCreateException;
import org.springmodules.jsr94.Jsr94RuleSessionTypeUnsupportedException;
import org.springmodules.jsr94.rulesource.RuleSource;
import org.springmodules.jsr94.support.Jsr94Accessor;
import org.springmodules.jsr94.support.StatefulRuleSessionCallback;
import org.springmodules.jsr94.support.StatelessRuleSessionCallback;

public class Jsr94Template
extends Jsr94Accessor {
    protected final Log logger = LogFactory.getLog((Class)(class$org$springmodules$jsr94$core$Jsr94Template == null ? (class$org$springmodules$jsr94$core$Jsr94Template = Jsr94Template.class$("org.springmodules.jsr94.core.Jsr94Template")) : class$org$springmodules$jsr94$core$Jsr94Template));
    static /* synthetic */ Class class$org$springmodules$jsr94$core$Jsr94Template;

    public Jsr94Template() {
    }

    public Jsr94Template(RuleSource ruleSource) {
        this.setRuleSource(ruleSource);
        this.afterPropertiesSet();
    }

    private RuleSession createRuleSession(String uri, Map properties, int type) {
        try {
            return this.getRuleSource().createSession(uri, properties, type);
        }
        catch (RuleExecutionSetNotFoundException ex) {
            throw new Jsr94RuleExecutionSetNotFoundException(ex);
        }
        catch (RuleSessionTypeUnsupportedException ex) {
            throw new Jsr94RuleSessionTypeUnsupportedException(ex);
        }
        catch (RuleSessionCreateException ex) {
            throw new Jsr94RuleSessionCreateException(ex);
        }
        catch (RemoteException ex) {
            throw new Jsr94RemoteException(ex);
        }
    }

    private void releaseStatelessSession(StatelessRuleSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        try {
            session.release();
        }
        catch (InvalidRuleSessionException ex) {
            throw new Jsr94InvalidRuleSessionException(ex);
        }
        catch (RemoteException ex) {
            throw new Jsr94RemoteException(ex);
        }
    }

    private void releaseStatefulSession(StatefulRuleSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        try {
            session.release();
        }
        catch (InvalidRuleSessionException ex) {
            throw new Jsr94InvalidRuleSessionException(ex);
        }
        catch (RemoteException ex) {
            throw new Jsr94RemoteException(ex);
        }
    }

    public Object executeStateless(String uri, Map properties, StatelessRuleSessionCallback callback) {
        StatelessRuleSession session = (StatelessRuleSession)this.createRuleSession(uri, properties, 1);
        try {
            Object object = callback.execute(session);
            return object;
        }
        catch (InvalidRuleSessionException ex) {
            throw new Jsr94InvalidRuleSessionException(ex);
        }
        catch (RemoteException ex) {
            throw new Jsr94RemoteException(ex);
        }
        finally {
            this.releaseStatelessSession(session);
        }
    }

    public Object executeStateful(String uri, Map properties, StatefulRuleSessionCallback callback) {
        StatefulRuleSession session;
        boolean synchronize = TransactionSynchronizationManager.isSynchronizationActive();
        if (!synchronize) {
            this.logger.debug((Object)"Not running in transaction; the session will be closed when the callback returns.");
        }
        if ((session = (StatefulRuleSession)TransactionSynchronizationManager.getResource((Object)this.getRuleSource())) == null) {
            this.logger.debug((Object)"Opening StatefulRuleSession");
            session = (StatefulRuleSession)this.createRuleSession(uri, properties, 0);
            if (synchronize) {
                TransactionSynchronizationManager.bindResource((Object)this.getRuleSource(), (Object)session);
            }
        }
        try {
            Object object = callback.execute(session);
            return object;
        }
        catch (InvalidRuleSessionException ex) {
            throw new Jsr94InvalidRuleSessionException(ex);
        }
        catch (RemoteException ex) {
            throw new Jsr94RemoteException(ex);
        }
        catch (InvalidHandleException ex) {
            throw new Jsr94InvalidHandleException(ex);
        }
        finally {
            if (!synchronize) {
                this.releaseStatefulSession(session);
                this.logger.debug((Object)"Closed session");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

