/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.document;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractExcelView
extends AbstractView {
    private static final String EXTENSION = ".xls";
    private static final String SEPARATOR = "_";
    private String url;
    private HSSFWorkbook wb;

    public AbstractExcelView() {
        this.setContentType("application/vnd.ms-excel");
    }

    public void setUrl(String url) {
        this.url = url;
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.url != null) {
            this.wb = this.getTemplateSource(this.url, request);
        } else {
            this.wb = new HSSFWorkbook();
            this.logger.info((Object)"Excel WorkBook created from scratch");
        }
        this.buildExcelDocument(model, this.wb, request, response);
        response.setContentType(this.getContentType());
        ServletOutputStream out = response.getOutputStream();
        this.wb.write((OutputStream)out);
        out.flush();
    }

    protected HSSFWorkbook getTemplateSource(String url, HttpServletRequest request) throws ServletException {
        String source = null;
        String realPath = null;
        FileInputStream inputFile = null;
        Locale userLocale = RequestContextUtils.getLocale(request);
        String lang = userLocale.getLanguage();
        String country = userLocale.getCountry();
        if (country.length() > 1) {
            source = url + SEPARATOR + lang + country + EXTENSION;
            realPath = this.getServletContext().getRealPath(source);
            try {
                inputFile = new FileInputStream(realPath);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (lang.length() > 1 && null == inputFile) {
            source = url + SEPARATOR + lang + EXTENSION;
            realPath = this.getServletContext().getRealPath(source);
            try {
                inputFile = new FileInputStream(realPath);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (null == inputFile) {
            source = url + EXTENSION;
            realPath = this.getServletContext().getRealPath(source);
            try {
                inputFile = new FileInputStream(realPath);
            }
            catch (FileNotFoundException e) {
                throw new ApplicationContextException("Can't resolve real path for EXCEL template at '" + source + "'; probably results from container restriction: override ExcelView.getTemplateSource() to use an alternative approach to getRealPath()");
            }
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(inputFile);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            this.logger.info((Object)("Loaded Excel workBook " + source));
            return workBook;
        }
        catch (IOException e) {
            throw new ApplicationContextException("IOException with '" + source + "': " + e.getMessage());
        }
    }

    protected abstract void buildExcelDocument(Map var1, HSSFWorkbook var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected HSSFCell getCell(HSSFSheet sheet, int row, int col) {
        HSSFCell cell;
        HSSFRow sheetRow = sheet.getRow(row);
        if (null == sheetRow) {
            sheetRow = sheet.createRow(row);
        }
        if (null == (cell = sheetRow.getCell((short)col))) {
            cell = sheetRow.createCell((short)col);
        }
        return cell;
    }

    protected void setText(HSSFCell cell, String text) {
        cell.setCellType(1);
        cell.setCellValue(text);
    }
}

