/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;

public class MockPageContext
extends PageContext {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletConfig servletConfig;
    private final Hashtable attributes = new Hashtable();

    public MockPageContext() {
        this(new MockServletContext());
    }

    public MockPageContext(ServletContext servletContext) {
        this(servletContext, new MockHttpServletRequest(servletContext));
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request) {
        this(servletContext, request, new MockHttpServletResponse());
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this(servletContext, request, response, new MockServletConfig(servletContext));
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
        this.request = request;
        this.response = response;
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new UnsupportedOperationException("Use appropriate constructor");
    }

    public void release() {
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAttribute(String name, Object value, int scope) {
        this.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        return this.getAttribute(name);
    }

    public Object findAttribute(String name) {
        return this.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeAttribute(String name, int scope) {
        this.removeAttribute(name);
    }

    public int getAttributesScope(String name) {
        return 1;
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        return this.attributes.keys();
    }

    public JspWriter getOut() {
        throw new UnsupportedOperationException("getOut");
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public Object getPage() {
        throw new UnsupportedOperationException("getException");
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        throw new UnsupportedOperationException("getException");
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void forward(String url) throws ServletException, IOException {
        throw new UnsupportedOperationException("forward");
    }

    public void include(String url) throws ServletException, IOException {
        throw new UnsupportedOperationException("include");
    }

    public void handlePageException(Exception ex) throws ServletException, IOException {
        throw new UnsupportedOperationException("handlePageException");
    }

    public void handlePageException(Throwable throwable) throws ServletException, IOException {
        throw new UnsupportedOperationException("handlePageException");
    }
}

