/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingResultSet;
import org.apache.commons.dbcp.DelegatingStatement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class CommonsDbcpNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    public Connection getNativeConnection(Connection con) throws SQLException {
        if (con instanceof DelegatingConnection) {
            Connection nativeCon = ((DelegatingConnection)con).getInnermostDelegate();
            return nativeCon != null ? nativeCon : con.getMetaData().getConnection();
        }
        return con;
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (stmt instanceof DelegatingStatement) {
            return ((DelegatingStatement)stmt).getInnermostDelegate();
        }
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        if (ps instanceof DelegatingPreparedStatement) {
            return ((DelegatingPreparedStatement)ps).getInnermostDelegate();
        }
        return ps;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        if (cs instanceof DelegatingCallableStatement) {
            return ((DelegatingCallableStatement)cs).getInnermostDelegate();
        }
        return cs;
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        if (rs instanceof DelegatingResultSet) {
            return ((DelegatingResultSet)rs).getInnermostDelegate();
        }
        return rs;
    }
}

