/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.util.ObjectUtils;

public class SingleConnectionDataSource
extends DriverManagerDataSource
implements DisposableBean {
    private boolean suppressClose;
    private Connection connection;

    public SingleConnectionDataSource() {
    }

    public SingleConnectionDataSource(String driverClassName, String url, String username, String password, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(driverClassName, url, username, password);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(Connection source, boolean suppressClose) {
        if (source == null) {
            throw new IllegalArgumentException("Connection is null in SingleConnectionDataSource");
        }
        this.suppressClose = suppressClose;
        this.init(source);
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    public boolean isSuppressClose() {
        return this.suppressClose;
    }

    public boolean shouldClose(Connection conn) {
        return false;
    }

    protected void init() throws SQLException {
        this.init(this.getConnectionFromDriverManager());
    }

    protected void init(Connection source) {
        this.connection = this.suppressClose ? DataSourceUtils.getCloseSuppressingConnectionProxy(source) : source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        SingleConnectionDataSource singleConnectionDataSource = this;
        synchronized (singleConnectionDataSource) {
            if (this.connection == null) {
                this.init();
            }
        }
        if (this.connection.isClosed()) {
            throw new SQLException("Connection was closed in SingleConnectionDataSource. Check that user code checks shouldClose() before closing connections, or set suppressClose to true");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning single connection: " + this.connection));
        }
        return this.connection;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (ObjectUtils.nullSafeEquals((Object)username, (Object)this.getUsername()) && ObjectUtils.nullSafeEquals((Object)password, (Object)this.getPassword())) {
            return this.getConnection();
        }
        throw new SQLException("SingleConnectionDataSource does not support custom username and password");
    }

    public void destroy() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

