/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;

public class DataBinder {
    public static final String MISSING_FIELD_ERROR_CODE = "required";
    private BindException errors;
    private String[] allowedFields;
    private String[] requiredFields;

    public DataBinder(Object target, String objectName) {
        this.errors = this.createErrors(target, objectName);
    }

    protected BindException createErrors(Object target, String objectName) {
        return new BindException(target, objectName);
    }

    public Object getTarget() {
        return this.errors.getTarget();
    }

    public String getObjectName() {
        return this.errors.getObjectName();
    }

    public BindException getErrors() {
        return this.errors;
    }

    public void setAllowedFields(String[] allowedFields) {
        this.allowedFields = allowedFields;
    }

    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setRequiredFields(String[] requiredFields) {
        this.requiredFields = requiredFields;
    }

    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.errors.getBeanWrapper().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String field, PropertyEditor propertyEditor) {
        this.errors.getBeanWrapper().registerCustomEditor(requiredType, field, propertyEditor);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.errors.setMessageCodesResolver(messageCodesResolver);
    }

    public void bind(PropertyValues pvs) {
        int i;
        PropertyValue[] pvArray = pvs.getPropertyValues();
        List<String> allowedFieldsList = this.allowedFields != null ? Arrays.asList(this.allowedFields) : null;
        MutablePropertyValues mpvs = pvs instanceof MutablePropertyValues ? (MutablePropertyValues)pvs : new MutablePropertyValues(pvs);
        for (i = 0; i < pvArray.length; ++i) {
            String field = pvArray[i].getName();
            if (allowedFieldsList != null && allowedFieldsList.contains(field) || this.isAllowed(field)) continue;
            mpvs.removePropertyValue(pvArray[i]);
        }
        pvs = mpvs;
        if (this.requiredFields != null) {
            for (i = 0; i < this.requiredFields.length; ++i) {
                PropertyValue pv = pvs.getPropertyValue(this.requiredFields[i]);
                if (pv != null && !"".equals(pv.getValue()) && pv.getValue() != null) continue;
                String field = this.requiredFields[i];
                this.errors.addError(new FieldError(this.errors.getObjectName(), field, "", true, this.errors.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, field), this.getArgumentsForBindingError(field), "Field '" + field + "' is required"));
            }
        }
        try {
            this.errors.getBeanWrapper().setPropertyValues(pvs, true);
        }
        catch (PropertyAccessExceptionsException ex) {
            PropertyAccessException[] exs = ex.getPropertyAccessExceptions();
            for (int i2 = 0; i2 < exs.length; ++i2) {
                String field = exs[i2].getPropertyChangeEvent().getPropertyName();
                this.errors.addError(new FieldError(this.errors.getObjectName(), field, exs[i2].getPropertyChangeEvent().getNewValue(), true, this.errors.resolveMessageCodes(exs[i2].getErrorCode(), field), this.getArgumentsForBindingError(field), exs[i2].getLocalizedMessage()));
            }
        }
    }

    protected boolean isAllowed(String field) {
        if (this.allowedFields != null) {
            for (int i = 0; i < this.allowedFields.length; ++i) {
                String allowed = this.allowedFields[i];
                if ((!allowed.endsWith("*") || !field.startsWith(allowed.substring(0, allowed.length() - 1))) && (!allowed.startsWith("*") || !field.endsWith(allowed.substring(1, allowed.length())))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected Object[] getArgumentsForBindingError(String field) {
        return new Object[]{new DefaultMessageSourceResolvable(new String[]{this.getObjectName() + "." + field, field}, null, field)};
    }

    public Map close() throws BindException {
        if (this.errors.hasErrors()) {
            throw this.errors;
        }
        return this.errors.getModel();
    }
}

