/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ContextSingletonBeanFactoryLocator
extends SingletonBeanFactoryLocator {
    public static final String BEANS_REFS_XML_NAME = "beanRefContext.xml";
    private static Map instances = new HashMap();

    public static BeanFactoryLocator getInstance() throws BeansException {
        return ContextSingletonBeanFactoryLocator.getInstance(BEANS_REFS_XML_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws BeansException {
        Map map = instances;
        synchronized (map) {
            Object bfl;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ContextSingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances));
            }
            if ((bfl = (BeanFactoryLocator)instances.get(selector)) == null) {
                bfl = new ContextSingletonBeanFactoryLocator(selector);
                instances.put(selector, bfl);
            }
            return bfl;
        }
    }

    protected ContextSingletonBeanFactoryLocator() {
        super(BEANS_REFS_XML_NAME);
    }

    protected ContextSingletonBeanFactoryLocator(String resourceName) {
        super(resourceName);
    }

    protected BeanFactory createDefinition(String[] resources) throws BeansException {
        return new FileSystemXmlApplicationContext(resources);
    }

    protected void destroyDefinition(BeanFactory groupDef, String resourceName) throws BeansException {
        if (groupDef instanceof ConfigurableApplicationContext) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ContextSingletonBeanFactoryLocator group with resourceName '" + resourceName + "' being released, as no more references."));
            }
            ((ConfigurableApplicationContext)groupDef).close();
        }
    }
}

