/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.core.Ordered;

public class DefaultIntroductionAdvisor
implements IntroductionAdvisor,
ClassFilter,
Ordered {
    private int order = Integer.MAX_VALUE;
    private IntroductionInterceptor interceptor;
    private Set interfaces = new HashSet();

    public DefaultIntroductionAdvisor(IntroductionInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public DefaultIntroductionAdvisor(IntroductionInterceptor interceptor, Class clazz) {
        this(interceptor);
        this.addInterface(clazz);
    }

    public DefaultIntroductionAdvisor(DelegatingIntroductionInterceptor dii) {
        this((IntroductionInterceptor)dii);
        Class[] introducedInterfaces = dii.getIntroducedInterfaces();
        for (int i = 0; i < introducedInterfaces.length; ++i) {
            this.addInterface(introducedInterfaces[i]);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void addInterface(Class intf) {
        this.interfaces.add(intf);
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public Advice getAdvice() {
        return this.interceptor;
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void validateInterfaces() throws IllegalArgumentException {
        Iterator ut = this.interfaces.iterator();
        while (ut.hasNext()) {
            Class intf = (Class)ut.next();
            if (!intf.isInterface()) {
                throw new IllegalArgumentException("Class '" + intf.getName() + "' is not an interface; cannot be used in an introduction");
            }
            if (this.interceptor.implementsInterface(intf)) continue;
            throw new IllegalArgumentException("IntroductionInterceptor [" + this.interceptor + "] " + "does not implement interface '" + intf.getName() + "' specified in introduction advice");
        }
    }
}

