/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pub.codex.common.column.BaseColumn;
import pub.codex.common.db.jdbc.TableDao;
import pub.codex.common.field.ControllerlClass;
import pub.codex.common.models.CodexResult;
import pub.codex.common.models.R;
import pub.codex.common.utils.BaseUtil;
import pub.codex.common.utils.TranslateUtil;
import pub.codex.core.provider.ConfigProvider;
import pub.codex.core.template.stream.template.TableCodexTemplateStream;

@RestController
public class CodexcController {
    private byte[] downloadByteBucket;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private TableDao tableDao;
    @Autowired
    private TableCodexTemplateStream tableCodexTemplateStream;

    @GetMapping(value={"/codex/generate/table/option"})
    public CodexResult codex() {
        List tableList = this.tableDao.queryTableList();
        return CodexResult.ok().put("tableList", (Object)tableList).put("package", (Object)this.configProvider.getPackageInfo()).put("prefix", (Object)this.configProvider.getPrefix()).put("jdbc", (Object)this.configProvider.getJdbcInfo());
    }

    @GetMapping(value={"/codex/generate/table/attribute/detail/{tableName}"})
    public CodexResult infoResponse(@PathVariable String tableName) {
        List columns = this.tableDao.queryColumns(tableName);
        List baseColumns = columns.stream().map(item -> {
            BaseColumn baseColumn = new BaseColumn();
            baseColumn.setComments((String)item.get("columnComment"));
            String attrName = TranslateUtil.columnToJava((String)((String)item.get("columnName")));
            baseColumn.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = BaseUtil.getConfig().getString((String)item.get("dataType"), "unknowType");
            baseColumn.setAttrType(attrType);
            Object maxLength = item.get("maxLength");
            if (maxLength != null) {
                baseColumn.setMaxLength(maxLength.toString());
            } else {
                baseColumn.setMaxLength("-");
            }
            if ("PRI".equalsIgnoreCase((String)item.get("columnKey"))) {
                baseColumn.setPrimary("primary");
            }
            return baseColumn;
        }).collect(Collectors.toList());
        return CodexResult.ok().put("attributes", baseColumns);
    }

    @GetMapping(value={"/codex/generate/code/default/{tableName}"})
    public void code(HttpServletResponse response, @PathVariable String tableName, @RequestParam(required=false) String tablePrefix) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.tableCodexTemplateStream.doTemplate(tableName, null, tablePrefix, zip);
        IOUtils.closeQuietly((OutputStream)zip);
        byte[] data = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + tableName + ".zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/codex/generate/code/controller/{tableName}"})
    public R createController(@PathVariable String tableName, @RequestParam(required=false) String tablePrefix, @RequestBody ControllerlClass controllerlClass) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.tableCodexTemplateStream.doTemplate(tableName, controllerlClass, tablePrefix.trim(), zip);
        IOUtils.closeQuietly((OutputStream)zip);
        this.downloadByteBucket = outputStream.toByteArray();
        return R.ok();
    }

    @GetMapping(value={"/codex/generate/code/downloadByteBucket/{tableName}"})
    public ResponseEntity<?> downloadByteBucket(HttpServletResponse response, @PathVariable String tableName) throws IOException {
        if (this.downloadByteBucket == null || this.downloadByteBucket.length <= 0) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + tableName + ".zip\"");
        response.addHeader("Content-Length", "" + this.downloadByteBucket.length);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])this.downloadByteBucket, (OutputStream)response.getOutputStream());
        this.downloadByteBucket = null;
        return new ResponseEntity(HttpStatus.OK);
    }
}

