/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class CodexCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String url = context.getEnvironment().getProperty("codex.jdbc.url");
        if (StringUtils.isEmpty((Object)url)) {
            return false;
        }
        String entity1 = context.getEnvironment().getProperty("codex.package.entityPath");
        String entity2 = context.getEnvironment().getProperty("codex.package.entity-path");
        if (StringUtils.isEmpty((Object)entity1) && StringUtils.isEmpty((Object)entity2)) {
            return false;
        }
        String mapper1 = context.getEnvironment().getProperty("codex.package.mapperPath");
        String mapper2 = context.getEnvironment().getProperty("codex.package.mapper-path");
        if (StringUtils.isEmpty((Object)mapper1) && StringUtils.isEmpty((Object)mapper2)) {
            return false;
        }
        String mapperXML1 = context.getEnvironment().getProperty("codex.package.mapperXMLPath");
        String mapperXML2 = context.getEnvironment().getProperty("codex.package.mapperXML-path");
        if (StringUtils.isEmpty((Object)mapperXML1) && StringUtils.isEmpty((Object)mapperXML2)) {
            return false;
        }
        String service1 = context.getEnvironment().getProperty("codex.package.servicePath");
        String service2 = context.getEnvironment().getProperty("codex.package.service-path");
        if (StringUtils.isEmpty((Object)service1) && StringUtils.isEmpty((Object)service2)) {
            return false;
        }
        String serviceImpl1 = context.getEnvironment().getProperty("codex.package.serviceImplPath");
        String serviceImpl2 = context.getEnvironment().getProperty("codex.package.serviceImpl-path");
        if (StringUtils.isEmpty((Object)serviceImpl1) && StringUtils.isEmpty((Object)serviceImpl2)) {
            return false;
        }
        String controller1 = context.getEnvironment().getProperty("codex.package.controllerPath");
        String controller2 = context.getEnvironment().getProperty("codex.package.controller-path");
        return !StringUtils.isEmpty((Object)controller1) || !StringUtils.isEmpty((Object)controller2);
    }
}

