/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.controller;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pub.codex.common.column.ControllerColumn;
import pub.codex.common.column.InfoColumn;
import pub.codex.common.db.jdbc.TableDao;
import pub.codex.common.models.CodexResult;
import pub.codex.common.utils.BaseUtil;
import pub.codex.common.utils.TranslateUtil;
import pub.codex.core.provider.ConfigProvider;
import pub.codex.core.template.stream.template.TableCodexTemplateStream;

@RestController
public class CodexcController {
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private TableDao tableDao;
    @Autowired
    private TableCodexTemplateStream tableCodexTemplateStream;

    @GetMapping(value={"/codex/data"})
    public CodexResult codex() {
        List tableList = this.tableDao.queryTableList();
        return CodexResult.ok().put("tableList", (Object)tableList).put("package", (Object)this.configProvider.getPackageInfo()).put("prefix", (Object)this.configProvider.getPrefix()).put("jdbc", (Object)this.configProvider.getJdbcInfo());
    }

    @GetMapping(value={"/codex/info/{tableName}"})
    public CodexResult infoResponse(@PathVariable String tableName) {
        List columns = this.tableDao.queryColumns(tableName);
        ArrayList<InfoColumn> infoList = new ArrayList<InfoColumn>();
        for (Map column : columns) {
            InfoColumn infoColumn = new InfoColumn();
            infoColumn.setComments((String)column.get("columnComment"));
            String attrName = TranslateUtil.columnToJava((String)((String)column.get("columnName")));
            infoColumn.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = BaseUtil.getConfig().getString((String)column.get("dataType"), "unknowType");
            infoColumn.setAttrType(attrType);
            if ("PRI".equalsIgnoreCase((String)column.get("columnKey"))) {
                infoColumn.setPrimary("primary");
            }
            infoList.add(infoColumn);
        }
        return CodexResult.ok().put("info", infoList);
    }

    @GetMapping(value={"/codex/code/{tableName}"})
    public void code(HttpServletResponse response, @PathVariable String tableName, @RequestParam(required=false) String tablePrefix) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.tableCodexTemplateStream.doTemplate(tableName, null, tablePrefix, zip);
        IOUtils.closeQuietly((OutputStream)zip);
        byte[] data = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + tableName + ".zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/codex/generate/{tableName}"})
    public void createController(HttpServletRequest request, HttpServletResponse response, @PathVariable String tableName, @RequestParam(required=false) String tablePrefix) throws IOException {
        String dataBody = request.getParameter("data");
        ControllerColumn controllerColumn = (ControllerColumn)JSON.parseObject((String)dataBody, ControllerColumn.class);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.tableCodexTemplateStream.doTemplate(tableName, controllerColumn, tablePrefix.trim(), zip);
        IOUtils.closeQuietly((OutputStream)zip);
        byte[] data = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + tableName + ".zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }
}

