/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pub.codex.common.db.jdbc.TableDao;
import pub.codex.common.models.CodexResult;
import pub.codex.core.provider.ConfigProvider;
import pub.codex.core.template.stream.template.TableCodexTemplateStream;

@RestController
public class CodexcController {
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private TableDao tableDao;
    @Autowired
    private TableCodexTemplateStream tableCodexTemplateStream;

    @GetMapping(value={"/codex/data"})
    public CodexResult codex() {
        List tableList = this.tableDao.queryTableList();
        return CodexResult.ok().put("tableList", (Object)tableList).put("package", (Object)this.configProvider.getPackageInfo()).put("prefix", (Object)this.configProvider.getPrefix());
    }

    @GetMapping(value={"/codex/code/{tableName}"})
    public void code(HttpServletResponse response, @PathVariable String tableName, @RequestParam(required=false) String tablePrefix) throws IOException {
        byte[] data = this.tableCodexTemplateStream.doTemplate(tableName, tablePrefix);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + tableName + ".zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }
}

