/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.template;

import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pub.codex.common.db.entity.TableEntity;
import pub.codex.common.db.jdbc.TableDao;
import pub.codex.common.field.ControllerlClass;
import pub.codex.core.template.stream.provider.TableEntityProvider;
import pub.codex.core.template.stream.template.TableCodexTemplate;

@Component
public class TableCodexTemplateStream {
    @Autowired
    private List<TableCodexTemplate> tableCodexTemplateList;
    @Autowired
    private TableDao tableDao;
    @Autowired
    TableEntityProvider tableEntityProvider;

    public void doTemplate(String tableName, ControllerlClass controllerlClass, String tablePrefix, ZipOutputStream zip) {
        Map<String, String> table = this.getTable(tableName);
        List<Map<String, String>> columns = this.getColumns(tableName);
        TableEntity tableEntity = this.tableEntityProvider.buildTemplateEntity(table, columns, controllerlClass, tablePrefix);
        this.tableCodexTemplateList.stream().forEach(tableCodexTemplate -> tableCodexTemplate.build(tableEntity, zip));
    }

    private Map<String, String> getTable(String tableName) {
        return this.tableDao.queryTable(tableName);
    }

    private List<Map<String, String>> getColumns(String tableName) {
        return this.tableDao.queryColumns(tableName);
    }
}

