/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import pub.codex.common.Constant;
import pub.codex.common.db.entity.ColumnEntity;
import pub.codex.common.db.entity.TableEntity;
import pub.codex.common.field.BaseField;
import pub.codex.common.field.ControllerMethod;
import pub.codex.common.field.ControllerlClass;
import pub.codex.common.utils.BaseUtil;
import pub.codex.common.utils.TranslateUtil;
import pub.codex.core.template.stream.build.ValidateAnnotationBuild;

@Component
public class TableEntityProvider {
    @Autowired
    private ValidateAnnotationBuild validateAnnotationBuild;

    public TableEntity buildTemplateEntity(Map<String, String> table, List<Map<String, String>> columns, ControllerlClass controllerlClass, String tablePrefix) {
        TableEntity tableEntity = new TableEntity();
        ArrayList<String> typeList = new ArrayList<String>();
        tableEntity.setTableName(table.get("tableName"));
        tableEntity.setComments(table.get("tableComment"));
        Map interfaceMap = BaseUtil.getPropertyByMethod((ControllerlClass)controllerlClass);
        if (interfaceMap != null) {
            for (String type : interfaceMap.keySet()) {
                typeList.add(type);
            }
        }
        tableEntity.setInterfaceType(typeList);
        String className = TranslateUtil.tableToJava((String)tableEntity.getTableName(), (String)tablePrefix);
        tableEntity.setClassName(className);
        tableEntity.setClassname(StringUtils.uncapitalize((String)className));
        ArrayList<ColumnEntity> columsList = new ArrayList<ColumnEntity>();
        for (Map<String, String> column : columns) {
            ColumnEntity columnEntity = new ColumnEntity();
            columnEntity.setColumnName(column.get("columnName"));
            columnEntity.setDataType(column.get("dataType"));
            columnEntity.setComments(column.get("columnComment"));
            columnEntity.setExtra(column.get("extra"));
            String attrName = TranslateUtil.columnToJava((String)columnEntity.getColumnName());
            columnEntity.setAttrName(attrName);
            columnEntity.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = BaseUtil.getConfig().getString(columnEntity.getDataType(), "unknowType");
            columnEntity.setAttrType(attrType);
            columnEntity.setAnnotationList(this.combAnnotation(interfaceMap, columnEntity.getAttrname(), columnEntity.getComments()));
            columnEntity.setQueryList(this.combQueryStr(interfaceMap, columnEntity.getAttrname(), columnEntity.getAttrName(), column.get("columnName"), tableEntity));
            if ("PRI".equalsIgnoreCase(column.get("columnKey")) && tableEntity.getPk() == null) {
                tableEntity.setPk(columnEntity);
            }
            columsList.add(columnEntity);
        }
        tableEntity.setColumns(columsList);
        tableEntity.setController(controllerlClass != null);
        return tableEntity;
    }

    private List<String> combQueryStr(Map<String, ControllerMethod> interfaceMap, String column, String attrName, String columnName, TableEntity tableEntity) {
        if (interfaceMap == null || interfaceMap.get(Constant.interfaceConstant.LIST.getType()) == null) {
            return null;
        }
        ArrayList<String> queryList = new ArrayList<String>();
        ControllerMethod controllerMethod = interfaceMap.get(Constant.interfaceConstant.LIST.getType());
        Map interfaceColumn = TranslateUtil.transformUtils((List)controllerMethod.getFields());
        BaseField baseField = (BaseField)interfaceColumn.get(column);
        if (baseField.getAnnotation() != null) {
            if (baseField.getAnnotation().equals(Constant.query.LIKE.getValue())) {
                queryList.add(".like(!StringUtils.isEmpty(" + tableEntity.getClassname() + "Entity.get" + attrName + "()),\"" + columnName + "\", " + tableEntity.getClassname() + "Entity.get" + attrName + "())");
            }
            if (baseField.getAnnotation().equals(Constant.query.EQUAL.getValue())) {
                queryList.add(".eq(!StringUtils.isEmpty(" + tableEntity.getClassname() + "Entity.get" + attrName + "()),\"" + columnName + "\", " + tableEntity.getClassname() + "Entity.get" + attrName + "())");
            }
        }
        return queryList;
    }

    private List<String> combAnnotation(Map<String, ControllerMethod> interfaceMap, String column, String comments) {
        if (interfaceMap == null) {
            return null;
        }
        ArrayList<String> annotation = new ArrayList<String>();
        HashMap<String, StringBuffer> groupMap = new HashMap<String, StringBuffer>();
        for (String type : interfaceMap.keySet()) {
            if (type.equals(Constant.interfaceConstant.LIST.getValue())) continue;
            this.findAnnotation(interfaceMap.get(type), type, column, groupMap);
        }
        this.validateAnnotationBuild.baseAnnotationFactory(annotation, groupMap, Constant.annotationConatant.NOTNULL);
        this.validateAnnotationBuild.baseAnnotationFactory(annotation, groupMap, Constant.annotationConatant.NOTEMPTY);
        this.validateAnnotationBuild.baseAnnotationFactory(annotation, groupMap, Constant.annotationConatant.NULL);
        this.validateAnnotationBuild.baseAnnotationFactory(annotation, groupMap, Constant.annotationConatant.PATTERN);
        this.validateAnnotationBuild.NotBlankAnnotationFactory(annotation, groupMap);
        this.validateAnnotationBuild.apiModelPropertyAnnotationFactory(annotation, groupMap, comments);
        return annotation;
    }

    private void findAnnotation(ControllerMethod controllerMethod, String type, String column, Map<String, StringBuffer> map) {
        if (controllerMethod == null || controllerMethod.getFields() == null) {
            return;
        }
        String value = Constant.interfaceConstant.getGroupInfo((String)type);
        if (StringUtils.isEmpty((Object)value)) {
            return;
        }
        Map interfaceColumn = TranslateUtil.transformUtils((List)controllerMethod.getFields());
        BaseField baseField = (BaseField)interfaceColumn.get(column);
        if (map.get(baseField.getAnnotation()) != null) {
            StringBuffer stringBuffer = map.get(baseField.getAnnotation());
            map.put(baseField.getAnnotation(), stringBuffer.append(value + ","));
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            map.put(baseField.getAnnotation(), stringBuffer.append(value + ","));
        }
    }
}

