/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import pub.codex.common.Constant;
import pub.codex.common.column.BaseColumn;
import pub.codex.common.column.ControllerColumn;
import pub.codex.common.column.FieldColumn;
import pub.codex.common.db.entity.ColumnEntity;
import pub.codex.common.db.entity.TableEntity;
import pub.codex.common.utils.BaseUtil;
import pub.codex.common.utils.TranslateUtil;

@Component
public class TableEntityProvider {
    public TableEntity buildTemplateEntity(Map<String, String> table, List<Map<String, String>> columns, ControllerColumn controllerColumn, String tablePrefix) {
        TableEntity tableEntity = new TableEntity();
        ArrayList<String> typeList = new ArrayList<String>();
        tableEntity.setTableName(table.get("tableName"));
        tableEntity.setComments(table.get("tableComment"));
        Map interfaceMap = BaseUtil.getMethod((ControllerColumn)controllerColumn);
        if (interfaceMap != null) {
            for (String type : interfaceMap.keySet()) {
                typeList.add(type);
            }
        }
        tableEntity.setInterfaceType(typeList);
        String className = TranslateUtil.tableToJava((String)tableEntity.getTableName(), (String)tablePrefix);
        tableEntity.setClassName(className);
        tableEntity.setClassname(StringUtils.uncapitalize((String)className));
        ArrayList<ColumnEntity> columsList = new ArrayList<ColumnEntity>();
        for (Map<String, String> column : columns) {
            ColumnEntity columnEntity = new ColumnEntity();
            columnEntity.setColumnName(column.get("columnName"));
            columnEntity.setDataType(column.get("dataType"));
            columnEntity.setComments(column.get("columnComment"));
            columnEntity.setExtra(column.get("extra"));
            String attrName = TranslateUtil.columnToJava((String)columnEntity.getColumnName());
            columnEntity.setAttrName(attrName);
            columnEntity.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = BaseUtil.getConfig().getString(columnEntity.getDataType(), "unknowType");
            columnEntity.setAttrType(attrType);
            columnEntity.setAnnotationList(this.combAnnotation(interfaceMap, columnEntity.getAttrname(), columnEntity.getComments()));
            columnEntity.setQueryList(this.combQueryStr(interfaceMap, columnEntity.getAttrname(), columnEntity.getAttrName(), column.get("columnName"), tableEntity));
            if ("PRI".equalsIgnoreCase(column.get("columnKey")) && tableEntity.getPk() == null) {
                tableEntity.setPk(columnEntity);
            }
            columsList.add(columnEntity);
        }
        tableEntity.setColumns(columsList);
        tableEntity.setController(controllerColumn != null);
        return tableEntity;
    }

    private List<String> combQueryStr(Map<String, FieldColumn> interfaceMap, String column, String attrName, String columnName, TableEntity tableEntity) {
        if (interfaceMap == null || interfaceMap.get(Constant.interfaceConstant.LIST.getType()) == null) {
            return null;
        }
        ArrayList<String> queryList = new ArrayList<String>();
        FieldColumn fieldColumn = interfaceMap.get(Constant.interfaceConstant.LIST.getType());
        Map interfaceColumn = TranslateUtil.transformUtils((List)fieldColumn.getTableData());
        BaseColumn baseColumn = (BaseColumn)interfaceColumn.get(column);
        if (baseColumn.getAnnotation() != null) {
            if (baseColumn.getAnnotation().equals(Constant.query.LIKE.getValue())) {
                queryList.add(".like(!StringUtils.isEmpty(" + tableEntity.getClassname() + "Entity.get" + attrName + "()),\"" + columnName + "\", " + tableEntity.getClassname() + "Entity.get" + attrName + "())");
            }
            if (baseColumn.getAnnotation().equals(Constant.query.EQUAL.getValue())) {
                queryList.add(".eq(!StringUtils.isEmpty(" + tableEntity.getClassname() + "Entity.get" + attrName + "()),\"" + columnName + "\", " + tableEntity.getClassname() + "Entity.get" + attrName + "())");
            }
        }
        return queryList;
    }

    private List<String> combAnnotation(Map<String, FieldColumn> interfaceMap, String column, String comments) {
        if (interfaceMap == null) {
            return null;
        }
        ArrayList<String> annotation = new ArrayList<String>();
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        for (String type : interfaceMap.keySet()) {
            if (type == Constant.interfaceConstant.LIST.getValue()) continue;
            this.findAnnotation(interfaceMap.get(type), type, column, map);
        }
        this.annotationFactory(annotation, map, Constant.annotationConatant.NOTNULL, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NOTBLANK, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NOTEMPTY, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NULL, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.PATTERN, null);
        if (this.annotationFactory(annotation, map, Constant.annotationConatant.APIMODELPROPERTY, comments) == Constant.flag.APIMODELPROPERTY_ANNOTATION) {
            return annotation;
        }
        if (comments != null && !comments.equals("")) {
            annotation.add(Constant.annotationConatant.APIMODELPROPERTY.getValue() + "(\"" + comments + "\")");
        }
        return annotation;
    }

    private Constant.flag annotationFactory(List<String> annotation, Map<String, StringBuffer> map, Constant.annotationConatant annoEnum, String comments) {
        if (map.get(annoEnum.getValue()) == null) {
            return Constant.flag.NULL_EXCEPTION;
        }
        if (annoEnum.getValue().equals(Constant.annotationConatant.APIMODELPROPERTY.getValue())) {
            StringBuffer groups = map.get(annoEnum.getValue());
            if (!StringUtils.isEmpty((Object)comments)) {
                annotation.add(Constant.annotationConatant.APIMODELPROPERTY.getValue() + "(describe = \"" + comments + "\",groups = {" + groups.deleteCharAt(groups.length() - 1) + "})");
            }
            return Constant.flag.APIMODELPROPERTY_ANNOTATION;
        }
        StringBuffer groups = map.get(annoEnum.getValue());
        annotation.add(annoEnum.getValue() + "(groups = {" + groups.deleteCharAt(groups.length() - 1) + "})");
        return Constant.flag.EXTERNAL_ANNOTATION;
    }

    private void findAnnotation(FieldColumn fieldColumn, String type, String column, Map<String, StringBuffer> map) {
        if (fieldColumn == null || fieldColumn.getTableData() == null) {
            return;
        }
        String value = Constant.interfaceConstant.getGroupInfo((String)type);
        if (StringUtils.isEmpty((Object)value)) {
            return;
        }
        Map interfaceColumn = TranslateUtil.transformUtils((List)fieldColumn.getTableData());
        BaseColumn baseColumn = (BaseColumn)interfaceColumn.get(column);
        if (map.get(baseColumn.getAnnotation()) != null) {
            StringBuffer stringBuffer = map.get(baseColumn.getAnnotation());
            map.put(baseColumn.getAnnotation(), stringBuffer.append(value + ","));
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            map.put(baseColumn.getAnnotation(), stringBuffer.append(value + ","));
        }
    }
}

