/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.template;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.springframework.util.StringUtils;
import pub.codex.common.CodexException;
import pub.codex.common.Constant;
import pub.codex.common.db.entity.ColumnEntity;
import pub.codex.common.db.entity.TableEntity;
import pub.codex.common.models.BaseColumn;
import pub.codex.common.models.ControllerColumn;
import pub.codex.common.models.FieldColumn;
import pub.codex.core.template.stream.template.BaseTableCodexTemplate;

public abstract class TableCodexTemplate
extends BaseTableCodexTemplate {
    protected TableEntity tableEntity = new TableEntity();
    protected ZipOutputStream zip;

    public abstract void coding();

    public void buildTemplateEntity(Map<String, String> table, List<Map<String, String>> columns, ControllerColumn controllerColumn, String tablePrefix, ZipOutputStream zip) {
        this.tableEntity.setTableName(table.get("tableName"));
        this.tableEntity.setComments(table.get("tableComment"));
        String className = this.tableToJava(this.tableEntity.getTableName(), tablePrefix);
        this.tableEntity.setClassName(className);
        this.tableEntity.setClassname(StringUtils.uncapitalize((String)className));
        ArrayList<ColumnEntity> columsList = new ArrayList<ColumnEntity>();
        for (Map<String, String> column : columns) {
            List<Object> annotationList = new ArrayList();
            ColumnEntity columnEntity = new ColumnEntity();
            columnEntity.setColumnName(column.get("columnName"));
            columnEntity.setDataType(column.get("dataType"));
            columnEntity.setComments(column.get("columnComment"));
            columnEntity.setExtra(column.get("extra"));
            String attrName = this.columnToJava(columnEntity.getColumnName());
            columnEntity.setAttrName(attrName);
            columnEntity.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = this.getConfig().getString(columnEntity.getDataType(), "unknowType");
            columnEntity.setAttrType(attrType);
            if (controllerColumn != null) {
                annotationList = this.combAnnotation(controllerColumn, columnEntity.getAttrname(), columnEntity.getComments());
            }
            columnEntity.setAnnotationList(annotationList);
            if ("PRI".equalsIgnoreCase(column.get("columnKey")) && this.tableEntity.getPk() == null) {
                this.tableEntity.setPk(columnEntity);
            }
            columsList.add(columnEntity);
        }
        this.tableEntity.setColumns(columsList);
        this.zip = zip;
        this.coding();
    }

    private List<String> combAnnotation(ControllerColumn controllerColumn, String column, String comments) {
        ArrayList<String> annotation = new ArrayList<String>();
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        this.findAnnotation(controllerColumn.getAdd(), Constant.interfaceConstant.ADD.getValue(), column, map);
        this.findAnnotation(controllerColumn.getDel(), Constant.interfaceConstant.DELETE.getValue(), column, map);
        this.findAnnotation(controllerColumn.getDetail(), Constant.interfaceConstant.GET.getValue(), column, map);
        this.findAnnotation(controllerColumn.getUpdate(), Constant.interfaceConstant.UPDATE.getValue(), column, map);
        this.findAnnotation(controllerColumn.getList(), Constant.interfaceConstant.LIST.getValue(), column, map);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NOTNULL, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NOTBLANK, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NOTEMPTY, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.NULL, null);
        this.annotationFactory(annotation, map, Constant.annotationConatant.PATTERN, null);
        if (this.annotationFactory(annotation, map, Constant.annotationConatant.APIMODELPROPERTY, comments) == Constant.flag.APIMODELPROPERTY_ANNOTATION) {
            return annotation;
        }
        if (comments != null && !comments.equals("")) {
            annotation.add(Constant.annotationConatant.APIMODELPROPERTY.getValue() + "(\"" + comments + "\")");
        }
        return annotation;
    }

    private Constant.flag annotationFactory(List<String> annotation, Map<String, StringBuffer> map, Constant.annotationConatant annoEnum, String comments) {
        if (map.get(annoEnum.getValue()) == null) {
            return Constant.flag.NULL_EXCEPTION;
        }
        if (annoEnum.getValue().equals(Constant.annotationConatant.APIMODELPROPERTY.getValue())) {
            StringBuffer groups = map.get(annoEnum.getValue());
            if (comments != null && !comments.equals("")) {
                annotation.add(Constant.annotationConatant.APIMODELPROPERTY.getValue() + "(\"" + comments + "\",groups = {" + groups.deleteCharAt(groups.length() - 1) + "})");
            }
            return Constant.flag.APIMODELPROPERTY_ANNOTATION;
        }
        StringBuffer groups = map.get(annoEnum.getValue());
        annotation.add(annoEnum.getValue() + "(groups = {" + groups.deleteCharAt(groups.length() - 1) + "})");
        return Constant.flag.EXTERNAL_ANNOTATION;
    }

    private void findAnnotation(FieldColumn fieldColumn, String value, String column, Map<String, StringBuffer> map) {
        if (fieldColumn == null || fieldColumn.getTableData() == null) {
            return;
        }
        Map<String, BaseColumn> interfaceColumn = this.transformUtils(fieldColumn.getTableData());
        BaseColumn baseColumn = interfaceColumn.get(column);
        if (map.get(baseColumn.getAnnotation()) != null) {
            StringBuffer stringBuffer = map.get(baseColumn.getAnnotation());
            map.put(baseColumn.getAnnotation(), stringBuffer.append(value + ","));
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            map.put(baseColumn.getAnnotation(), stringBuffer.append(value + ","));
        }
    }

    private Map<String, BaseColumn> transformUtils(List<BaseColumn> interfaceColumn) {
        if (interfaceColumn == null) {
            return null;
        }
        HashMap<String, BaseColumn> map = new HashMap<String, BaseColumn>();
        for (BaseColumn baseColumn : interfaceColumn) {
            map.put(baseColumn.getAttrname(), baseColumn);
        }
        return map;
    }

    protected void buildTemplate(String templateName, Map<String, Object> map, String filepath) {
        Template template = this.getTemplate(templateName);
        VelocityContext context = new VelocityContext(map);
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        try {
            this.zip.putNextEntry(new ZipEntry(filepath));
            IOUtils.write((String)sw.toString(), (OutputStream)this.zip, (String)"UTF-8");
            IOUtils.closeQuietly((Writer)sw);
            this.zip.closeEntry();
        }
        catch (IOException e) {
            throw new CodexException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + this.tableEntity.getClassName(), (Throwable)e);
        }
    }
}

