/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.template;

import java.io.File;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import pub.codex.common.CodexException;

public class BaseTableCodexTemplate {
    protected Template getTemplate(String templateName) {
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)prop);
        String TEMPLATE_PATH = String.format("template/%s.vm", templateName);
        Template template = Velocity.getTemplate((String)TEMPLATE_PATH, (String)"UTF-8");
        return template;
    }

    public String tableToJava(String tableName, String tablePrefix) {
        if (StringUtils.isNotBlank((CharSequence)tablePrefix)) {
            tableName = tableName.replace(tablePrefix, "");
        }
        return this.columnToJava(tableName);
    }

    public String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", "");
    }

    public Configuration getConfig() {
        try {
            return new PropertiesConfiguration("generator.properties");
        }
        catch (ConfigurationException e) {
            throw new CodexException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c", (Throwable)e);
        }
    }

    protected String buildFilePath(String templateName, String className, String packagePath, boolean isResources) {
        String headPackagePath = !isResources ? "main" + File.separator + "java" + File.separator : "main" + File.separator + "resources" + File.separator;
        return headPackagePath + packagePath.replace(".", File.separator) + File.separator + className + templateName;
    }
}

