/*
 * Decompiled with CFR 0.152.
 */
package pro.wangfeng.common.lang;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static <K, T> Predicate<T> notNullResultFunction(Function<T, K> function) {
        return t -> !Objects.isNull(function.apply(t));
    }

    public static <K, T> Predicate<T> nullResultFunction(Function<T, K> function) {
        return t -> Objects.isNull(function.apply(t));
    }

    public static <T> Predicate<T> distinctByFunction(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap(16);
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

