/*
 * Decompiled with CFR 0.152.
 */
package pro.wangfeng.common.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.wangfeng.common.lang.StreamUtils;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<List<T>> splitList(List<T> list, int subSize) {
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        int size = list.size();
        for (int i = 0; i < size; i += subSize) {
            parts.add(new ArrayList<T>(list.subList(i, Math.min(size, i + subSize))));
        }
        return parts;
    }

    public static <E> boolean isNotEmpty(Collection<E> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <E> boolean isEmpty(Collection<E> collection) {
        return !CollectionUtils.isNotEmpty(collection);
    }

    public static <K, T> Map<K, List<T>> getMapGroupByFeature(List<T> list, Function<T, K> groupFeature) {
        return CollectionUtils.getMapGroupByFeature(list, groupFeature, t -> t);
    }

    public static <K, V, T> Map<K, List<V>> getMapGroupByFeature(List<T> list, Function<T, K> groupFeature, Function<T, V> mappingToList) {
        Map map = list.stream().filter(StreamUtils.notNullResultFunction(groupFeature)).collect(Collectors.groupingBy(groupFeature, Collectors.mapping(mappingToList, Collectors.toList())));
        List nullGroup = list.stream().filter(StreamUtils.nullResultFunction(groupFeature)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(nullGroup)) {
            map.put(null, nullGroup.stream().map(mappingToList).collect(Collectors.toList()));
        }
        return map;
    }

    public static <K, T> List<K> getGroupFeatureList(List<T> list, Function<T, K> groupFeature) {
        List ks = list.stream().filter(StreamUtils.notNullResultFunction(groupFeature)).map(groupFeature).distinct().sorted().collect(Collectors.toList());
        boolean hasNullFeature = list.stream().anyMatch(StreamUtils.nullResultFunction(groupFeature));
        if (hasNullFeature) {
            ks.add(null);
        }
        return ks;
    }

    public static <K, T> List<K> getGroupFeatureList(List<T> list, Function<T, K> groupFeature, Comparator<K> comparator) {
        Stream<K> stream = list.stream().filter(StreamUtils.notNullResultFunction(groupFeature)).map(groupFeature).distinct();
        if (comparator != null) {
            stream = stream.sorted(comparator);
        }
        List ks = stream.collect(Collectors.toList());
        boolean hasNullFeature = list.stream().anyMatch(StreamUtils.nullResultFunction(groupFeature));
        if (hasNullFeature) {
            ks.add(null);
        }
        return ks;
    }

    public static <K, T> List<T> getSubListByGroupFeature(List<T> list, Function<T, K> groupFeature, K k) {
        Map<K, List<T>> map = CollectionUtils.getMapGroupByFeature(list, groupFeature);
        return map.get(k);
    }

    public static <K, T> List<T> getFirstSubListByGroupFeature(List<T> list, Function<T, K> groupFeature, boolean asc) {
        List<K> keys = CollectionUtils.getGroupFeatureList(list, groupFeature);
        K k = asc ? keys.get(0) : keys.get(keys.size() - 1);
        return CollectionUtils.getSubListByGroupFeature(list, groupFeature, k);
    }

    public static <T, U> List<U> convertList(List<T> source, Function<T, U> func) {
        return source.stream().map(func).collect(Collectors.toList());
    }

    public static <T, U> U[] convertArray(T[] source, Function<T, U> func, IntFunction<U[]> generator) {
        return Arrays.stream(source).map(func).toArray(generator);
    }
}

