/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.taskanaconnector.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pro.taskana.adapter.exceptions.TaskCreationFailedException;
import pro.taskana.adapter.exceptions.TaskTerminationFailedException;
import pro.taskana.adapter.systemconnector.api.ReferencedTask;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;
import pro.taskana.adapter.taskanaconnector.api.impl.TaskInformationMapper;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

@Component
public class TaskanaSystemConnectorImpl
implements TaskanaConnector {
    static final String REFERENCED_TASK_ID = "referenced_task_id";
    static final String REFERENCED_TASK_VARIABLES = "referenced_task_variables";
    static final String SYSTEM_URL = "system_url";
    private static final String TASK_STATE_CANCELLED = "CANCELLED";
    private static final String TASK_STATE_TERMINATED = "TERMINATED";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaSystemConnectorImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskInformationMapper taskInformationMapper;

    public List<ReferencedTask> retrieveFinishedTaskanaTasksAsReferencedTasks() {
        List finishedTasks = this.taskService.createTaskQuery().stateIn(new TaskState[]{TaskState.COMPLETED, TaskState.CANCELLED, TaskState.TERMINATED}).callbackStateIn(new CallbackState[]{CallbackState.CALLBACK_PROCESSING_REQUIRED, CallbackState.CLAIMED}).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following taskana tasks were completed {} and must process their callback.", (Object)finishedTasks);
        }
        return this.retrieveTaskanaTasksAndConvertToReferencedTasks(finishedTasks);
    }

    public List<ReferencedTask> retrieveClaimedTaskanaTasksAsReferencedTasks() {
        List claimedTasks = this.taskService.createTaskQuery().stateIn(new TaskState[]{TaskState.CLAIMED}).callbackStateIn(new CallbackState[]{CallbackState.CALLBACK_PROCESSING_REQUIRED}).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following taskana tasks were claimed {} and must process their callback.", (Object)claimedTasks);
        }
        return this.retrieveTaskanaTasksAndConvertToReferencedTasks(claimedTasks);
    }

    public List<ReferencedTask> retrieveCancelledClaimTaskanaTasksAsReferencedTasks() {
        List claimedTasks = this.taskService.createTaskQuery().stateIn(new TaskState[]{TaskState.READY}).callbackStateIn(new CallbackState[]{CallbackState.CLAIMED}).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the claims of the following taskana tasks were cancelled {} and  must process their callback.", (Object)claimedTasks);
        }
        return this.retrieveTaskanaTasksAndConvertToReferencedTasks(claimedTasks);
    }

    public void changeTaskCallbackState(List<ReferencedTask> referencedTasks, CallbackState callbackState) {
        List externalIds = referencedTasks.stream().map(ReferencedTask::getId).collect(Collectors.toList());
        if (!externalIds.isEmpty()) {
            this.taskService.setCallbackStateForTasks(externalIds, callbackState);
        }
    }

    public void createTaskanaTask(Task taskanaTask) throws TaskCreationFailedException {
        try {
            this.taskService.createTask(taskanaTask);
        }
        catch (ClassificationNotFoundException | InvalidArgumentException | NotAuthorizedException | TaskAlreadyExistException | WorkbasketNotFoundException e) {
            LOGGER.error("Caught Exception {} when creating taskana task {} ", (Object)e, (Object)taskanaTask);
            throw new TaskCreationFailedException("Error when creating a taskana task " + taskanaTask, e);
        }
    }

    public Task convertToTaskanaTask(ReferencedTask camundaTask) {
        return this.taskInformationMapper.convertToTaskanaTask(camundaTask);
    }

    public ReferencedTask convertToReferencedTask(Task task) {
        return this.taskInformationMapper.convertToReferencedTask(task);
    }

    public void terminateTaskanaTask(ReferencedTask referencedTask) throws TaskTerminationFailedException {
        String taskId = null;
        TaskSummary taskSummary = null;
        try {
            taskSummary = (TaskSummary)this.taskService.createTaskQuery().externalIdIn(new String[]{referencedTask.getId()}).single();
            if (taskSummary != null) {
                taskId = taskSummary.getId();
                switch (referencedTask.getTaskState()) {
                    case "TERMINATED": {
                        this.taskService.terminateTask(taskId);
                        break;
                    }
                    case "CANCELLED": {
                        this.taskService.cancelTask(taskId);
                        break;
                    }
                    default: {
                        this.taskService.forceCompleteTask(taskId);
                    }
                }
                List externalIds = Stream.of(referencedTask.getId()).collect(Collectors.toList());
                this.taskService.setCallbackStateForTasks(externalIds, CallbackState.CALLBACK_PROCESSING_COMPLETED);
            }
        }
        catch (TaskNotFoundException e1) {
            LOGGER.debug("Nothing to do in terminateTaskanaTask. Task {} is already gone", taskId);
        }
        catch (NotAuthorizedException | InvalidOwnerException | InvalidStateException e2) {
            if (TaskState.COMPLETED.equals((Object)taskSummary.getState())) {
                LOGGER.debug("Nothing to do in terminateTaskanaTask. Task {} is already completed", taskId);
            }
            throw new TaskTerminationFailedException("Task termination failed for task " + taskId, e2);
        }
    }

    private List<ReferencedTask> retrieveTaskanaTasksAndConvertToReferencedTasks(List<TaskSummary> requestedTasks) {
        ArrayList<ReferencedTask> result = new ArrayList<ReferencedTask>();
        for (TaskSummary taskSummary : requestedTasks) {
            try {
                Task taskanaTask = this.taskService.getTask(taskSummary.getId());
                Map callbackInfo = taskanaTask.getCallbackInfo();
                if (callbackInfo == null || callbackInfo.get(REFERENCED_TASK_ID) == null || callbackInfo.get(SYSTEM_URL) == null) continue;
                result.add(this.taskInformationMapper.convertToReferencedTask(taskanaTask));
            }
            catch (NotAuthorizedException | TaskNotFoundException e) {
                LOGGER.error("Caught {} when trying to retrieve requested taskana tasks.", (Object)e, (Object)e);
            }
        }
        return result;
    }
}

