/*
 * Decompiled with CFR 0.152.
 */
package pro.parseq.GenomeExplorer;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.parseq.GenomeExplorer.ReferenceSequenceCase;
import pro.parseq.GenomeExplorer.exceptions.ContigNotFoundException;
import pro.parseq.GenomeExplorer.exceptions.IllegalReferencesFolderPathException;
import pro.parseq.GenomeExplorer.exceptions.NoSuchReferenceException;

public class Explorer {
    private static final Logger logger = LoggerFactory.getLogger(Explorer.class);
    private File referencesFolder;
    private Map<String, ReferenceSequenceFile> references;
    private static final FilenameFilter fastaFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String filename;
            String lowercaseName = name.toLowerCase();
            int endIndex = lowercaseName.length();
            if (lowercaseName.endsWith(".gz")) {
                endIndex -= 3;
            }
            return ReferenceSequenceFileFactory.FASTA_EXTENSIONS.contains((filename = lowercaseName.substring(0, endIndex)).substring(filename.lastIndexOf(".")));
        }
    };
    private static final FilenameFilter indexFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lowercaseName = name.toLowerCase();
            return lowercaseName.endsWith(".fai");
        }
    };
    private static final FilenameFilter dictionaryFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lowercaseName = name.toLowerCase();
            return lowercaseName.endsWith(".dict");
        }
    };

    public Explorer(String referencesFolderPath) throws IllegalReferencesFolderPathException {
        this.referencesFolder = new File(referencesFolderPath);
        if (!this.referencesFolder.isDirectory()) {
            throw new IllegalReferencesFolderPathException(referencesFolderPath);
        }
        this.references = new HashMap<String, ReferenceSequenceFile>();
        for (File referenceFolder : this.referencesFolder.listFiles()) {
            if (!referenceFolder.isDirectory()) continue;
            logger.debug("Found {} reference.", (Object)referenceFolder.getName());
            File[] referenceFile = referenceFolder.listFiles(fastaFilter);
            File[] indexFile = referenceFolder.listFiles(indexFilter);
            File[] dictionaryFile = referenceFolder.listFiles(dictionaryFilter);
            if (referenceFile.length < 1) {
                logger.error("No reference file found for {}! Skip it.", (Object)referenceFolder.getName());
                continue;
            }
            if (indexFile.length < 1) {
                logger.error("No index file found for {}! Skip it.", (Object)referenceFolder.getName());
                continue;
            }
            if (dictionaryFile.length < 1) {
                logger.error("No dictionary file found for {}! Skip it.", (Object)referenceFolder.getName());
                continue;
            }
            IndexedFastaSequenceFile referenceSequenceFile = new IndexedFastaSequenceFile(referenceFile[0], new FastaSequenceIndex(indexFile[0]));
            this.references.put(referenceFolder.getName(), (ReferenceSequenceFile)referenceSequenceFile);
        }
        logger.debug("Explorer found {} references.", (Object)this.references.size());
    }

    public Set<String> getReferenceGenomesList() {
        return this.references.keySet();
    }

    public boolean hasReference(String reference) {
        return this.references.containsKey(reference);
    }

    public boolean hasContig(String reference, String contig) throws NoSuchReferenceException {
        if (this.references.containsKey(reference)) {
            for (SAMSequenceRecord record : this.references.get(reference).getSequenceDictionary().getSequences()) {
                if (!record.getSequenceName().equals(contig)) continue;
                return true;
            }
            return false;
        }
        throw new NoSuchReferenceException(reference);
    }

    public long getContigLength(String reference, String contig) throws NoSuchReferenceException, ContigNotFoundException {
        if (this.references.containsKey(reference)) {
            for (SAMSequenceRecord record : this.references.get(reference).getSequenceDictionary().getSequences()) {
                if (!record.getSequenceName().equals(contig)) continue;
                return record.getSequenceLength();
            }
            throw new ContigNotFoundException(reference, contig);
        }
        throw new NoSuchReferenceException(reference);
    }

    public List<SAMSequenceRecord> getReferenceSequencesList(String reference) {
        if (this.references.containsKey(reference)) {
            return this.references.get(reference).getSequenceDictionary().getSequences();
        }
        logger.error("No such reference {}!", (Object)reference);
        return null;
    }

    public List<String> getReferenceContigsList(String reference) {
        if (this.references.containsKey(reference)) {
            ArrayList<String> contigs = new ArrayList<String>();
            for (SAMSequenceRecord record : this.references.get(reference).getSequenceDictionary().getSequences()) {
                contigs.add(record.getSequenceName());
            }
            return contigs;
        }
        logger.error("No such reference {}!", (Object)reference);
        return null;
    }

    public String getReferenceSequence(String reference, String contig, long start, long stop, ReferenceSequenceCase sequenceCase) {
        if (this.references.containsKey(reference)) {
            String sequence = new String(this.references.get(reference).getSubsequenceAt(contig, start, stop).getBases());
            switch (sequenceCase) {
                case LOWER: {
                    return sequence.toLowerCase();
                }
                case UPPER: {
                    return sequence.toUpperCase();
                }
            }
            return sequence;
        }
        logger.error("No such reference {}!", (Object)reference);
        return null;
    }
}

