/*******************************************************************************
 * Copyright 2016-2017 the original author or authors.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package pro.parseq.GenomeExplorer.exceptions;

public class NoSuchReferenceException extends Exception {

	private static final long serialVersionUID = -1577652299745495825L;

	private String reference;

	public NoSuchReferenceException(String reference) {

		super("Reference genome of name '" + reference +
				"' is not found in the references dictionary!");

		this.reference = reference;
	}

	public String getReference() {
		return this.reference;
	}
}
