/*******************************************************************************
 * Copyright 2016-2017 the original author or authors.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package pro.parseq.GenomeExplorer.exceptions;

/**
 * Represents situation when "parent" references folder is not a directory
 * 
 * @author Alexander Afanasyev <a href="mailto:aafanasyev@parseq.pro">aafanasyev@parseq.pro</a>
 */
public class IllegalReferencesFolderPathException extends Exception {

	private static final long serialVersionUID = 803895331767472780L;

	private String path;

	public IllegalReferencesFolderPathException(String path) {

		super("References folder path must be a folder: "
				+ path + " is not a folder!");

		this.path = path;
	}

	public String getPath() {
		return this.path;
	}
}
