/*******************************************************************************
 * Copyright 2016-2017 the original author or authors.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package pro.parseq.GenomeExplorer.exceptions;

public class ContigNotFoundException extends Exception {

	private static final long serialVersionUID = -5235809502520662636L;

	private String reference;
	private String contig;

	public ContigNotFoundException(String reference, String contig) {

		super("Contig '" + contig + "' not found for reference genome '"
				+ reference + "'!");

		this.reference = reference;
		this.contig = contig;
	}

	public String getReference() {
		return this.reference;
	}

	public String getContig() {
		return this.contig;
	}
}
