/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.test;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import pro.foundev.cassandra.commons.core.CassandraConfiguration;
import pro.foundev.cassandra.commons.core.CassandraSessionFactory;
import pro.foundev.cassandra.commons.core.config.ConfigFinder;
import pro.foundev.cassandra.commons.core.config.ConfigFinderImpl;
import pro.foundev.cassandra.commons.test.FullTableName;

public class CassandraTestDB
implements Closeable {
    private final CassandraSessionFactory sessionFactory;
    protected final Session session;
    private PreparedStatement findTableStatement;
    private final Set<FullTableName> tablesMarkedForCleanup = new HashSet<FullTableName>();
    private Set<String> keySpacesMarkedForCleanup = new HashSet<String>();

    private synchronized Set<FullTableName> getTablesMarkedForCleanup() {
        return this.tablesMarkedForCleanup;
    }

    private synchronized void resetTablesMarkedForCleanup() {
        this.tablesMarkedForCleanup.clear();
    }

    protected synchronized void markForCleanUp(FullTableName fullTableName) {
        this.tablesMarkedForCleanup.add(fullTableName);
    }

    public CassandraTestDB(CassandraSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.session = sessionFactory.getSession();
        this.findTableStatement = this.session.prepare("SELECT * FROM system.schema_columnfamilies where keyspace_name=? and columnfamily_name=?");
    }

    public static CassandraTestDB create() throws IOException {
        ConfigFinderImpl configFinder = new ConfigFinderImpl();
        return CassandraTestDB.create((ConfigFinder)configFinder);
    }

    public static CassandraTestDB create(ConfigFinder configFinder) throws IOException {
        CassandraConfiguration configuration = CassandraConfiguration.parse((String)configFinder.find());
        CassandraSessionFactory sessionFactory = new CassandraSessionFactory(configuration);
        return new CassandraTestDB(sessionFactory);
    }

    public void cleanUp() {
        this.getTablesMarkedForCleanup().forEach(t -> {
            Row row = this.session.execute((Statement)this.findTableStatement.bind(new Object[]{t.getKeyspaceName(), t.getTableName()})).one();
            if (row != null) {
                this.session.execute("TRUNCATE " + t);
            }
        });
        this.resetTablesMarkedForCleanup();
        this.keySpacesMarkedForCleanup.forEach(k -> this.session.execute("DROP KEYSPACE IF EXISTS " + k));
        this.keySpacesMarkedForCleanup.clear();
    }

    public void markForCleanUp(String keyspace, String tableName) {
        FullTableName fullTableName = new FullTableName();
        fullTableName.setKeyspaceName(keyspace);
        fullTableName.setTableName(tableName);
        this.markForCleanUp(fullTableName);
    }

    public void markForCleanUp(String table) {
        String keyspace = this.session.getLoggedKeyspace();
        if (keyspace == null) {
            throw new RuntimeException("keyspace is null");
        }
        this.markForCleanUp(keyspace, table);
    }

    public Session getSession() {
        return this.session;
    }

    public void createTestKeyspace(String keyspaceName) {
        this.keySpacesMarkedForCleanup.add(keyspaceName);
        this.session.execute("CREATE KEYSPACE " + keyspaceName + " with replication " + "= {'class': 'SimpleStrategy', 'replication_factor':1 }");
    }

    public boolean tableExists(String keyspaceName, String tableName) {
        boolean exists;
        boolean bl = exists = null != this.session.execute("SELECT * FROM system.schema_columnfamilies where keyspace_name='" + keyspaceName + "' AND columnfamily_name='" + tableName + "'").one();
        if (exists) {
            FullTableName fullTableName = new FullTableName();
            fullTableName.setKeyspaceName(keyspaceName);
            fullTableName.setTableName(tableName);
        }
        return exists;
    }

    public void deleteTestKeyspaceIfExists(String keyspaceName) {
        this.session.execute("DROP KEYSPACE IF EXISTS " + keyspaceName);
    }

    @Override
    public void close() throws IOException {
        this.sessionFactory.close();
    }

    public ResultSet execute(Statement statement) {
        return this.session.execute(statement);
    }

    public Long count(String table) {
        return this.session.execute("SELECT COUNT(*) FROM " + table).one().getLong(0);
    }
}

