/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.foundev.cassandra.commons.test.spring;

import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import pro.foundev.cassandra.commons.test.CassandraTestDB;

/**
 * When applied to tests this cleans truncates tables that have used CassandraTestDB
 */
public class CassandraTableCleanupListener extends DependencyInjectionTestExecutionListener {

    /**
     * gets the singleton instance of CassandraTestDB and executes truncate on all known tables
     * @param testContext spring test context to inject
     * @throws Exception
     */
    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        CassandraTestDB cassandra = testContext.getApplicationContext().getBean(CassandraTestDB.class);
        cassandra.cleanUp();
        super.afterTestMethod(testContext);
    }
}
