/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.test.mapper;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.annotations.Table;
import pro.foundev.cassandra.commons.core.CassandraSessionFactory;
import pro.foundev.cassandra.commons.test.CassandraTestDB;
import pro.foundev.cassandra.commons.test.FullTableName;

public class CassandraMapperTestDB
extends CassandraTestDB {
    private final MappingManager mappingManager;

    public CassandraMapperTestDB(CassandraSessionFactory cassandraSessionFactory) {
        super(cassandraSessionFactory);
        this.mappingManager = new MappingManager(this.session);
    }

    public <T> void save(Class<T> klazz, T t) {
        this.getOrCreateMapper(klazz).save(t);
        this.markForCleanUp(klazz);
    }

    public Long count(Class<?> klazz) {
        FullTableName fullTableName = this.getTableNameFromClass(klazz);
        ResultSet resultSet = this.session.execute("SELECT COUNT(*) FROM " + fullTableName);
        Long count = resultSet.one().getLong(0);
        return count;
    }

    public synchronized void markForCleanUp(Class<?> klazz) {
        FullTableName fullTableName = this.getTableNameFromClass(klazz);
        super.markForCleanUp(fullTableName);
    }

    private <T> Mapper<T> getOrCreateMapper(Class<T> klazz) {
        Mapper mapper = this.mappingManager.mapper(klazz);
        return mapper;
    }

    private FullTableName getTableNameFromClass(Class<?> klazz) {
        Table tableAnnotation = klazz.getAnnotation(Table.class);
        String loggedKeyspace = this.session.getLoggedKeyspace();
        String keyspace = loggedKeyspace != null ? loggedKeyspace : tableAnnotation.keyspace();
        String name = tableAnnotation.name();
        FullTableName fullTableName = new FullTableName();
        fullTableName.setKeyspaceName(keyspace);
        fullTableName.setTableName(name);
        return fullTableName;
    }

    public <T> T get(Class<T> klazz, Object ... keys) {
        return (T)this.getOrCreateMapper(klazz).get(keys);
    }

    public <T> void delete(Class<T> klazz, Object ... keys) {
        this.getOrCreateMapper(klazz).delete(keys);
    }
}

