/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cassandra.commons.test.mapper.spring;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import pro.foundev.cassandra.commons.core.CassandraConfiguration;
import pro.foundev.cassandra.commons.core.CassandraSessionFactory;
import pro.foundev.cassandra.commons.core.config.ConfigFinder;
import pro.foundev.cassandra.commons.core.config.ConfigFinderImpl;
import pro.foundev.cassandra.test.mapper.CassandraMapperTestDB;

import java.io.IOException;

@Configuration
public class CassandraMapperTestContext {
    private ConfigFinder finder = new ConfigFinderImpl();
    @Bean
    @Scope(value = "singleton")
    public CassandraMapperTestDB cassandraTestDB() throws IOException {
        CassandraConfiguration configuration = CassandraConfiguration.parse(finder.find());
        CassandraSessionFactory sessionFactory = new CassandraSessionFactory(configuration);
        return new CassandraMapperTestDB(sessionFactory);
    }
}
