/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.migrations.script_parser;

import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ScriptParser {
    private boolean isDoubleSlashComment(char newChar, char lastChar) {
        return newChar == '/' && lastChar == '/';
    }

    private boolean isDoubleDashComment(char newChar, char lastChar) {
        return newChar == '-' && lastChar == '-';
    }

    private boolean isMultiLineStart(char newChar, char lastChar) {
        return newChar == '*' && lastChar == '/';
    }

    private boolean isMultilineEnd(char newChar, char lastChar) {
        return newChar == '/' && lastChar == '*';
    }

    public List<Statement> parse(Path file) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        StringBuffer cqlStatementBuffer = new StringBuffer();
        Charset charset = Charset.forName("UTF-8");
        try (BufferedReader reader = Files.newBufferedReader(file, charset);){
            int c;
            char lastChar = '\u0000';
            boolean commentOn = false;
            boolean multiLineCommentOn = false;
            while ((c = reader.read()) != -1) {
                char converted = (char)c;
                if (this.isMultiLineStart(converted, lastChar)) {
                    multiLineCommentOn = true;
                    cqlStatementBuffer = new StringBuffer();
                    continue;
                }
                if (this.isMultilineEnd(converted, lastChar)) {
                    multiLineCommentOn = false;
                    continue;
                }
                if (this.isDoubleDashComment(converted, lastChar) || this.isDoubleSlashComment(converted, lastChar)) {
                    commentOn = true;
                    cqlStatementBuffer = new StringBuffer();
                } else if (commentOn && converted == '\n') {
                    commentOn = false;
                }
                lastChar = converted;
                if (commentOn || multiLineCommentOn) continue;
                cqlStatementBuffer.append(converted);
                if (converted != 59) continue;
                statements.add(new SimpleStatement(cqlStatementBuffer.toString()));
                cqlStatementBuffer = new StringBuffer();
            }
            if (statements.size() == 0 && cqlStatementBuffer.length() > 0) {
                statements.add(new SimpleStatement(cqlStatementBuffer.toString()));
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return statements;
    }
}

