/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.migrations.cmd.arguments;

import java.util.Arrays;
import java.util.List;
import pro.foundev.cassandra.commons.migrations.cmd.arguments.MigrationConfiguration;

public class CommandLineArgumentsParser {
    public MigrationConfiguration parse(String[] args) {
        String scriptDirectory = "src/main/resources/cql";
        MigrationConfiguration configuration = new MigrationConfiguration();
        if (args.length < 2) {
            throw new IllegalArgumentException("must pass at least the following arguments: migrate|reset keyspace_name");
        }
        if (args.length > 7) {
            throw new IllegalArgumentException("You passed " + args.length + " arguments as the max is 7." + " Here is your command line: " + String.join((CharSequence)" ", args));
        }
        String command = args[0];
        if (!"migrate".equals(command) && !"reset".equals(command)) {
            throw new IllegalArgumentException("your first argument is '" + command + "' when the only valid argument " + "here is 'reset' or 'migrate'. Please choose one of those two and try again");
        }
        configuration.setCommand(command);
        String keyspace = args[1];
        configuration.setKeyspace(keyspace);
        if (args.length > 2) {
            scriptDirectory = args[2];
        }
        configuration.setScriptDirectory(scriptDirectory);
        String hostString = "127.0.0.1";
        if (args.length > 3) {
            hostString = args[3];
        }
        String[] hosts = hostString.split(",");
        List<String> hostsList = Arrays.asList(hosts);
        configuration.setHosts(hostsList);
        Integer port = 9042;
        if (args.length > 4) {
            port = Integer.parseInt(args[4]);
        }
        configuration.setPort(port);
        String username = "";
        if (args.length > 5) {
            username = args[5];
        }
        configuration.setUsername(username);
        String password = "";
        if (args.length > 6) {
            password = args[6];
        }
        configuration.setPassword(password);
        return configuration;
    }
}

