/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.migrations.cmd;

import java.io.FileNotFoundException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import pro.foundev.cassandra.commons.migrations.MigrationRunner;
import pro.foundev.cassandra.commons.migrations.MigrationRunnerImpl;
import pro.foundev.cassandra.commons.migrations.cmd.arguments.CommandLineArgumentsParser;
import pro.foundev.cassandra.commons.migrations.cmd.arguments.MigrationConfiguration;

public class MigrationCmdLine {
    private static MigrationRunner runner;

    public static void main(String[] args) throws FileNotFoundException {
        CommandLineArgumentsParser parser = new CommandLineArgumentsParser();
        MigrationConfiguration configuration = parser.parse(args);
        String scriptDirectory = configuration.getScriptDirectory();
        runner = new MigrationRunnerImpl(configuration);
        System.out.println("running " + configuration);
        String command = configuration.getCommand();
        if ("migrate".equals(command)) {
            MigrationCmdLine.migrate(scriptDirectory);
        } else if ("reset".equals(command)) {
            runner.resetKeyspace();
            MigrationCmdLine.migrate(scriptDirectory);
        }
    }

    private static void migrate(String scriptDirectory) throws FileNotFoundException {
        FileSystem fs = FileSystems.getDefault();
        runner.runScriptDirectory(fs.getPath(scriptDirectory, new String[0]));
    }
}

