/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.migrations;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.foundev.cassandra.commons.core.CassandraConfiguration;
import pro.foundev.cassandra.commons.core.CassandraSessionFactory;
import pro.foundev.cassandra.commons.migrations.Migration;
import pro.foundev.cassandra.commons.migrations.MigrationRunner;
import pro.foundev.cassandra.commons.migrations.parsing.MigrationFileName;
import pro.foundev.cassandra.commons.migrations.parsing.MigrationFileNameParser;
import pro.foundev.cassandra.commons.migrations.script_parser.ScriptParser;

public class MigrationRunnerImpl
implements MigrationRunner {
    private final CassandraConfiguration configuration;
    private Logger log = LoggerFactory.getLogger("MigrationRunnerLog");
    private final MigrationFileNameParser fileParser = new MigrationFileNameParser();
    private ScriptParser scriptParser = new ScriptParser();

    public MigrationRunnerImpl(String yamlConfig) throws IOException {
        this(CassandraConfiguration.parse(yamlConfig));
    }

    public MigrationRunnerImpl(CassandraConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void runScriptDirectory(Path scriptDirectory) throws FileNotFoundException {
        if (scriptDirectory == null || !Files.exists(scriptDirectory, new LinkOption[0])) {
            throw new FileNotFoundException("script directory is not present at :" + scriptDirectory);
        }
        String keyspace = this.configuration.getKeyspace();
        this.withSession(session -> {
            this.logAction("migrations starting");
            session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".migrations (migration_set int, version bigint, name text, cql text" + ", PRIMARY KEY(migration_set, version))");
            MappingManager manager = new MappingManager((Session)session);
            Mapper<Migration> mapper = manager.mapper(Migration.class);
            ResultSet rows = session.execute("SELECT * FROM migrations where migration_set=0 ORDER BY version DESC");
            Row latestMigrationFromDb = rows.one();
            Long latestVersionFromDB = 0L;
            if (latestMigrationFromDb != null) {
                latestVersionFromDB = latestMigrationFromDb.getLong("version");
            }
            final ArrayList migrations = new ArrayList();
            try {
                final Long finalLatestVersionFromDB = latestVersionFromDB;
                Files.walkFileTree(scriptDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = file.getFileName().toString();
                        if (!fileName.endsWith(".cql")) {
                            return FileVisitResult.CONTINUE;
                        }
                        MigrationFileName migrationFileName = MigrationRunnerImpl.this.fileParser.parseFileName(fileName);
                        String name = migrationFileName.getName();
                        Long version = migrationFileName.getVersion();
                        if (version > finalLatestVersionFromDB) {
                            List<Statement> statements = MigrationRunnerImpl.this.scriptParser.parse(file);
                            Migration migration = new Migration();
                            migration.setMigrationSet(0);
                            migration.setCqlToRun(statements);
                            migration.setVersion(version);
                            migration.setName(name);
                            migrations.add(migration);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                migrations.forEach(m -> {
                    try {
                        String migrationRun = String.format("running migration: %s with version: %d", m.getName(), m.getVersion());
                        this.logAction(migrationRun);
                        ArrayList executed = Lists.newArrayList();
                        m.getCqlToRun().forEach(s -> {
                            String trimmedStatement = null;
                            try {
                                trimmedStatement = s.toString().trim();
                                this.logAction(trimmedStatement);
                                session.execute((Statement)s);
                                executed.add(trimmedStatement);
                            }
                            catch (Exception ex) {
                                if (executed.size() > 0) {
                                    String executedCQL = String.join((CharSequence)";", executed);
                                    int step = executed.size() + 1;
                                    String.format("-- critical error: migration step #%d failed miserably. We do not know how to recover. Please review the exception and figure out the error in your migration script, then do the following:\n1. Make a new script and a new migration\n2. Fix your script and then add it to the new migration\n3. Save the migration that was successful with the following CQL: INSERT INTO migrations (migrations_set, version, name, cql) values\" +\n                            \" (%d, %d, '%s', '%s');Keep an eye out for https://github.com/rssvihla/cassandra-commons/issues/45 which will bring resumable migrations The CQL that failed was '%s", step, m.getMigrationSet(), m.getVersion(), m.getName(), executedCQL, trimmedStatement);
                                }
                                throw ex;
                            }
                        });
                    }
                    catch (Exception ex) {
                        String migrationError = String.format("failed migration: %s with version: %d", m.getName(), m.getVersion());
                        this.logError(migrationError, ex);
                        throw ex;
                    }
                    try {
                        mapper.save((Migration)m);
                    }
                    catch (Exception ex) {
                        this.logError("applied migration: create_table with version: 201510220938 but it failed writing the migration record to the migration table. Please review the error fix and manually insert the following CQL in the keyspace you are running migrations against to resolve the problem:\nINSERT INTO migrations (migrations_set, version, name, cql) values (%d, %d, '%s', '%s');", ex);
                    }
                    String completedRun = String.format("migration complete: %s with version: %d", m.getName(), m.getVersion());
                    this.logAction(completedRun);
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.logAction("migrations successfully completed");
        });
    }

    private void logError(String errorDescription, Throwable ex) {
        String paddedError = "-- " + errorDescription + " --";
        String errorPadding = this.padString(paddedError.length());
        this.log.error(errorPadding);
        this.log.error(paddedError, ex);
        this.log.error(errorPadding);
    }

    private void logAction(String actionDescription) {
        String paddedDescription = "-- " + actionDescription + " --";
        String completedPaddingBuffer = this.padString(paddedDescription.length());
        this.log.info(completedPaddingBuffer);
        this.log.info(paddedDescription);
        this.log.info(completedPaddingBuffer);
    }

    private String padString(int length) {
        StringBuffer runPaddingBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            runPaddingBuffer.append("-");
        }
        return runPaddingBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withSession(Consumer<Session> sessionConsumer) {
        CassandraSessionFactory cassandraSessionFactory = null;
        try {
            cassandraSessionFactory = new CassandraSessionFactory(this.configuration);
            sessionConsumer.accept(cassandraSessionFactory.getSession());
        }
        finally {
            if (cassandraSessionFactory != null) {
                try {
                    cassandraSessionFactory.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("was able to close cassandra session factory");
                }
            }
        }
    }

    @Override
    public void resetKeyspace() {
        String keyspaceName = this.configuration.getKeyspace();
        this.withSession(session -> {
            Row row = session.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name='" + keyspaceName + "'").one();
            if (row == null) {
                throw new RuntimeException("there is no keyspace by the name of " + keyspaceName);
            }
            String strategyClass = "SimpleStrategy";
            String strategyOptions = "'replication_factor':1";
            Boolean durableWrites = row.getBool("durable_writes");
            session.execute("DROP KEYSPACE " + keyspaceName);
            String createCql = "CREATE KEYSPACE " + keyspaceName + " WITH REPLICATION = {'class':'" + strategyClass + "', " + strategyOptions + "} AND DURABLE_WRITES=" + durableWrites;
            session.execute(createCql);
        });
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

