/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import pro.foundev.cassandra.commons.core.config.ConfigFinder;
import pro.foundev.cassandra.commons.core.properties.PropertyFinder;
import pro.foundev.cassandra.commons.core.properties.PropertyFinderImpl;
import pro.foundev.cassandra.commons.core.resources.ResourceReader;
import pro.foundev.cassandra.commons.core.resources.ResourceReaderImpl;

public class ConfigFinderImpl
implements ConfigFinder {
    private final String errorMessage = "I cannot find the cassandra.yaml file I'm giving up. Either: \n\t1. pass it as the system property cassandraYaml.\n\t2. drop a cassandra.yaml into the test resource directory.\n\t3. drop a cassandra.properties file into the test resource directory with the cassandraYaml property set.";
    private PropertyFinder propertyFinder = new PropertyFinderImpl();
    private ResourceReader resourceReader = new ResourceReaderImpl();

    @Override
    public String find() {
        String cassandraYaml = this.propertyFinder.getCassandraYaml();
        if (cassandraYaml == null) {
            URL yamlResource = this.resourceReader.get("/cassandra.yaml");
            if (yamlResource == null) {
                URL propertyFile = this.resourceReader.get("/cassandra.properties");
                if (propertyFile != null) {
                    yamlResource = this.readPropertyFile(propertyFile);
                    if (yamlResource == null) {
                        throw new RuntimeException("I cannot find the cassandra.yaml file I'm giving up. Either: \n\t1. pass it as the system property cassandraYaml.\n\t2. drop a cassandra.yaml into the test resource directory.\n\t3. drop a cassandra.properties file into the test resource directory with the cassandraYaml property set.");
                    }
                    return yamlResource.getPath();
                }
                throw new RuntimeException("I cannot find the cassandra.yaml file I'm giving up. Either: \n\t1. pass it as the system property cassandraYaml.\n\t2. drop a cassandra.yaml into the test resource directory.\n\t3. drop a cassandra.properties file into the test resource directory with the cassandraYaml property set.");
            }
            cassandraYaml = yamlResource.getPath();
        }
        return cassandraYaml;
    }

    private URL readPropertyFile(URL propertyFile) {
        URL yamlResource;
        block12: {
            Properties prop = new Properties();
            FileInputStream input = null;
            try {
                input = new FileInputStream(propertyFile.getPath());
                prop.load(input);
                String cassandraYamlPath = prop.getProperty("cassandraYaml");
                if (cassandraYamlPath == null) {
                    throw new RuntimeException("property file is missing cassandraYaml");
                }
                File file = new File(cassandraYamlPath);
                if (file != null && file.exists()) {
                    yamlResource = file.toURI().toURL();
                    break block12;
                }
                throw new RuntimeException("I cannot find the cassandra.yaml file I'm giving up. Either: \n\t1. pass it as the system property cassandraYaml.\n\t2. drop a cassandra.yaml into the test resource directory.\n\t3. drop a cassandra.properties file into the test resource directory with the cassandraYaml property set.");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return yamlResource;
    }

    public void setPropertyFinder(PropertyFinder propertyFinder) {
        this.propertyFinder = propertyFinder;
    }

    public void setResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }
}

