/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.core;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import pro.foundev.cassandra.commons.core.properties.PropertyFinder;
import pro.foundev.cassandra.commons.core.properties.PropertyFinderImpl;

public class CassandraConfiguration {
    private String password;
    private String username;
    private String keyspace;
    private Integer port;
    private List<String> hosts;
    private static Logger logger = LoggerFactory.getLogger(CassandraConfiguration.class);

    public static CassandraConfiguration parse(String yamlFilePath) throws IOException {
        return CassandraConfiguration.parse(yamlFilePath, new PropertyFinderImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CassandraConfiguration parse(String yamlFilePath, PropertyFinder propertyFinder) throws IOException {
        if (yamlFilePath == null || !new File(yamlFilePath).exists()) {
            throw new FileNotFoundException("unable to parse yaml file at: " + yamlFilePath);
        }
        Yaml yaml = new Yaml(new Constructor(CassandraConfiguration.class));
        try (InputStream input = null;){
            String password;
            String username;
            String keyspace;
            String port;
            input = new FileInputStream(new File(yamlFilePath));
            CassandraConfiguration configuration = (CassandraConfiguration)yaml.load(input);
            String hosts = propertyFinder.getHosts();
            if (hosts != null && !hosts.isEmpty()) {
                logger.info("overriding hosts: " + hosts);
                ArrayList<String> hostList = Lists.newArrayList(hosts.split(","));
                configuration.setHosts(hostList);
            }
            if ((port = propertyFinder.getPort()) != null && !port.isEmpty()) {
                logger.info("overriding port: " + port);
                Integer portNumber = Integer.parseInt(port);
                configuration.setPort(portNumber);
            }
            if ((keyspace = propertyFinder.getKeyspace()) != null && !keyspace.isEmpty()) {
                logger.info("overriding keyspace: " + keyspace);
                configuration.setKeyspace(keyspace);
            }
            if ((username = propertyFinder.getUsername()) != null && !username.isEmpty()) {
                logger.info("overriding username: " + username);
                configuration.setUsername(username);
            }
            if ((password = propertyFinder.getPassword()) != null && !password.isEmpty()) {
                logger.info("overriding password: " + password);
                configuration.setPassword(password);
            }
            CassandraConfiguration cassandraConfiguration = configuration;
            return cassandraConfiguration;
        }
    }

    public boolean hasCreds() {
        return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

