/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.InferredCQLType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UDTMapper<T> {
    private static final ProtocolVersion UDT_PROTOCOL_VERSION = ProtocolVersion.V3;
    private final EntityMapper<T> entityMapper;
    private final UserType userType;

    UDTMapper(EntityMapper<T> entityMapper, Session session) {
        this.entityMapper = entityMapper;
        String keyspace = entityMapper.getKeyspace();
        String udt = entityMapper.getTable();
        this.userType = session.getCluster().getMetadata().getKeyspace(keyspace).getUserType(udt);
        if (this.userType == null) {
            throw new IllegalArgumentException(String.format("Type \"%s\" does not exist in keyspace \"%s\"", udt, keyspace));
        }
    }

    public T fromUDT(UDTValue v) {
        if (!v.getType().equals(this.userType)) {
            String message = String.format("UDT conversion mismatch: expected type %s, got %s", this.userType, v.getType());
            throw new IllegalArgumentException(message);
        }
        return this.toEntity(v);
    }

    public UDTValue toUDT(T entity) {
        UDTValue udtValue = this.userType.newValue();
        for (ColumnMapper<T> cm : this.entityMapper.allColumns()) {
            Object value = cm.getValue(entity);
            udtValue.setBytesUnsafe(cm.getColumnName(), value == null ? null : cm.getDataType().serialize(value, UDT_PROTOCOL_VERSION));
        }
        return udtValue;
    }

    UserType getUserType() {
        return this.userType;
    }

    T toEntity(UDTValue udtValue) {
        T entity = this.entityMapper.newEntity();
        for (ColumnMapper<T> cm : this.entityMapper.allColumns()) {
            ByteBuffer bytes = udtValue.getBytesUnsafe(cm.getColumnName());
            if (bytes == null) continue;
            cm.setValue(entity, cm.getDataType().deserialize(bytes, UDT_PROTOCOL_VERSION));
        }
        return entity;
    }

    static Object convertEntitiesToUDTs(Object value, InferredCQLType type) {
        if (value == null) {
            return null;
        }
        if (!type.containsMappedUDT) {
            return value;
        }
        if (type.udtMapper != null) {
            return type.udtMapper.toUDT(value);
        }
        if (type.dataType.getName() == DataType.Name.LIST) {
            InferredCQLType elementType = type.childTypes.get(0);
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : (List)value) {
                result.add(UDTMapper.convertEntitiesToUDTs(element, elementType));
            }
            return result;
        }
        if (type.dataType.getName() == DataType.Name.SET) {
            InferredCQLType elementType = type.childTypes.get(0);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            for (Object element : (Set)value) {
                result.add(UDTMapper.convertEntitiesToUDTs(element, elementType));
            }
            return result;
        }
        if (type.dataType.getName() == DataType.Name.MAP) {
            InferredCQLType keyType = type.childTypes.get(0);
            InferredCQLType valueType = type.childTypes.get(1);
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                result.put(UDTMapper.convertEntitiesToUDTs(entry.getKey(), keyType), UDTMapper.convertEntitiesToUDTs(entry.getValue(), valueType));
            }
            return result;
        }
        throw new IllegalArgumentException("Error converting " + value);
    }

    static Object convertUDTsToEntities(Object value, InferredCQLType type) {
        if (value == null) {
            return null;
        }
        if (!type.containsMappedUDT) {
            return value;
        }
        if (type.udtMapper != null) {
            return type.udtMapper.toEntity((UDTValue)value);
        }
        if (type.dataType.getName() == DataType.Name.LIST) {
            InferredCQLType elementType = type.childTypes.get(0);
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : (List)value) {
                result.add(UDTMapper.convertUDTsToEntities(element, elementType));
            }
            return result;
        }
        if (type.dataType.getName() == DataType.Name.SET) {
            InferredCQLType elementType = type.childTypes.get(0);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            for (Object element : (Set)value) {
                result.add(UDTMapper.convertUDTsToEntities(element, elementType));
            }
            return result;
        }
        if (type.dataType.getName() == DataType.Name.MAP) {
            InferredCQLType keyType = type.childTypes.get(0);
            InferredCQLType valueType = type.childTypes.get(1);
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                result.put(UDTMapper.convertUDTsToEntities(entry.getKey(), keyType), UDTMapper.convertUDTsToEntities(entry.getValue(), valueType));
            }
            return result;
        }
        throw new IllegalArgumentException("Error converting " + value);
    }
}

