/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.mapping.EnumType;
import com.datastax.driver.mapping.InferredCQLType;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import com.datastax.driver.mapping.UDTMapper;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashSet;

class MethodMapper {
    public final Method method;
    public final String queryString;
    public final ParamMapper[] paramMappers;
    private final ConsistencyLevel consistency;
    private final int fetchSize;
    private final boolean tracing;
    private Session session;
    private PreparedStatement statement;
    private boolean returnStatement;
    private Mapper<?> returnMapper;
    private boolean mapOne;
    private boolean async;

    MethodMapper(Method method, String queryString, ParamMapper[] paramMappers, ConsistencyLevel consistency, int fetchSize, boolean enableTracing) {
        this.method = method;
        this.queryString = queryString;
        this.paramMappers = paramMappers;
        this.consistency = consistency;
        this.fetchSize = fetchSize;
        this.tracing = enableTracing;
    }

    public void prepare(MappingManager manager, PreparedStatement ps) {
        this.session = manager.getSession();
        this.statement = ps;
        this.validateParameters();
        Class<?> returnType = this.method.getReturnType();
        if (Void.TYPE.isAssignableFrom(returnType) || ResultSet.class.isAssignableFrom(returnType)) {
            return;
        }
        if (Statement.class.isAssignableFrom(returnType)) {
            this.returnStatement = true;
            return;
        }
        if (ResultSetFuture.class.isAssignableFrom(returnType)) {
            this.async = true;
            return;
        }
        if (ListenableFuture.class.isAssignableFrom(returnType)) {
            this.async = true;
            Type k = ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
            if (k instanceof Class && ResultSet.class.isAssignableFrom((Class)k)) {
                return;
            }
            this.mapType(manager, returnType, k);
        } else {
            this.mapType(manager, returnType, this.method.getGenericReturnType());
        }
    }

    private void validateParameters() {
        if (this.method.isVarArgs()) {
            throw new IllegalArgumentException(String.format("Invalid varargs method %s in @Accessor interface", this.method.getName()));
        }
        ColumnDefinitions variables = this.statement.getVariables();
        HashSet<String> names = Sets.newHashSet();
        for (ColumnDefinitions.Definition variable : variables) {
            names.add(variable.getName());
        }
        if (this.method.getParameterTypes().length < names.size()) {
            throw new IllegalArgumentException(String.format("Not enough arguments for method %s, found %d but it should be at least the number of unique bind parameter names in the @Query (%d)", this.method.getName(), this.method.getParameterTypes().length, names.size()));
        }
        if (this.method.getParameterTypes().length > variables.size()) {
            throw new IllegalArgumentException(String.format("Too many arguments for method %s, found %d but it should be at most the number of bind parameters in the @Query (%d)", this.method.getName(), this.method.getParameterTypes().length, variables.size()));
        }
    }

    private void mapType(MappingManager manager, Class<?> fullReturnType, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            if (raw instanceof Class && Result.class.isAssignableFrom((Class)raw)) {
                type = pt.getActualTypeArguments()[0];
            } else {
                this.mapOne = true;
            }
        } else {
            this.mapOne = true;
        }
        if (!(type instanceof Class)) {
            throw new RuntimeException(String.format("Cannot map return of method %s to unsupported type %s", this.method, type));
        }
        try {
            this.returnMapper = manager.mapper((Class)type);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot map return to class " + fullReturnType, e);
        }
    }

    public Object invoke(Object[] args) {
        BoundStatement bs = this.statement.bind();
        ProtocolVersion protocolVersion = this.session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum();
        for (int i = 0; i < args.length; ++i) {
            this.paramMappers[i].setValue(bs, args[i], protocolVersion);
        }
        if (this.consistency != null) {
            bs.setConsistencyLevel(this.consistency);
        }
        if (this.fetchSize > 0) {
            bs.setFetchSize(this.fetchSize);
        }
        if (this.tracing) {
            bs.enableTracing();
        }
        if (this.returnStatement) {
            return bs;
        }
        if (this.async) {
            ResultSetFuture future = this.session.executeAsync(bs);
            if (this.returnMapper == null) {
                return future;
            }
            return this.mapOne ? Futures.transform(future, this.returnMapper.mapOneFunctionWithoutAliases) : Futures.transform(future, this.returnMapper.mapAllFunctionWithoutAliases);
        }
        ResultSet rs = this.session.execute(bs);
        if (this.returnMapper == null) {
            return rs;
        }
        Result<?> result = this.returnMapper.map(rs);
        return this.mapOne ? result.one() : result;
    }

    static class EnumParamMapper
    extends ParamMapper {
        private final EnumType enumType;

        public EnumParamMapper(String paramName, int paramIdx, EnumType enumType) {
            super(paramName, paramIdx);
            this.enumType = enumType;
        }

        @Override
        void setValue(BoundStatement boundStatement, Object arg, ProtocolVersion protocolVersion) {
            super.setValue(boundStatement, this.convert(arg), protocolVersion);
        }

        private Object convert(Object arg) {
            if (arg == null) {
                return arg;
            }
            switch (this.enumType) {
                case STRING: {
                    return arg.toString();
                }
                case ORDINAL: {
                    return ((Enum)arg).ordinal();
                }
            }
            throw new AssertionError();
        }
    }

    static class NestedUDTParamMapper
    extends ParamMapper {
        private final InferredCQLType inferredCQLType;

        NestedUDTParamMapper(String paramName, int paramIdx, InferredCQLType inferredCQLType) {
            super(paramName, paramIdx);
            this.inferredCQLType = inferredCQLType;
        }

        @Override
        void setValue(BoundStatement boundStatement, Object arg, ProtocolVersion protocolVersion) {
            super.setValue(boundStatement, UDTMapper.convertEntitiesToUDTs(arg, this.inferredCQLType), protocolVersion);
        }
    }

    static class UDTParamMapper<V>
    extends ParamMapper {
        private final UDTMapper<V> udtMapper;

        UDTParamMapper(String paramName, int paramIdx, UDTMapper<V> udtMapper) {
            super(paramName, paramIdx);
            this.udtMapper = udtMapper;
        }

        @Override
        void setValue(BoundStatement boundStatement, Object arg, ProtocolVersion protocolVersion) {
            Object entity = arg;
            UDTValue udtArg = arg != null ? this.udtMapper.toUDT(entity) : null;
            super.setValue(boundStatement, udtArg, protocolVersion);
        }
    }

    static class ParamMapper {
        private final String paramName;
        private final int paramIdx;
        private final DataType dataType;

        public ParamMapper(String paramName, int paramIdx, DataType dataType) {
            this.paramName = paramName;
            this.paramIdx = paramIdx;
            this.dataType = dataType;
        }

        public ParamMapper(String paramName, int paramIdx) {
            this(paramName, paramIdx, null);
        }

        void setValue(BoundStatement boundStatement, Object arg, ProtocolVersion protocolVersion) {
            ByteBuffer serializedArg;
            ByteBuffer byteBuffer = serializedArg = this.dataType == null ? DataType.serializeValue(arg, protocolVersion) : this.dataType.serialize(arg, protocolVersion);
            if (this.paramName == null) {
                if (arg == null) {
                    boundStatement.setToNull(this.paramIdx);
                } else {
                    boundStatement.setBytesUnsafe(this.paramIdx, serializedArg);
                }
            } else if (arg == null) {
                boundStatement.setToNull(this.paramName);
            } else {
                boundStatement.setBytesUnsafe(this.paramName, serializedArg);
            }
        }
    }
}

