/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.TypeMappings;
import com.datastax.driver.mapping.UDTMapper;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

class InferredCQLType {
    final DataType dataType;
    final boolean containsMappedUDT;
    final UDTMapper udtMapper;
    final List<InferredCQLType> childTypes;

    static InferredCQLType from(Field field, MappingManager mappingManager) {
        String name = String.format("field %s of class %s", field.getName(), field.getDeclaringClass().getName());
        return new InferredCQLType(field.getGenericType(), name, field.getGenericType(), mappingManager);
    }

    static InferredCQLType from(String className, String methodName, int idx, String paramName, Type paramType, MappingManager mappingManager) {
        String name = String.format("parameter %s of %s.%s", paramName == null ? Integer.valueOf(idx) : paramName, className, methodName);
        return new InferredCQLType(paramType, name, paramType, mappingManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InferredCQLType(Type javaType, String rootName, Type rootType, MappingManager mappingManager) {
        if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Type raw = pt.getRawType();
            if (!(raw instanceof Class)) {
                throw this.fail(rootName, rootType);
            }
            Class klass = (Class)raw;
            if (!TypeMappings.mapsToCollection(klass)) {
                throw this.fail(rootName, rootType);
            }
            this.childTypes = Lists.newArrayList();
            boolean childrenContainMappedUDT = false;
            for (Type childJavaType : pt.getActualTypeArguments()) {
                InferredCQLType child = new InferredCQLType(childJavaType, rootName, rootType, mappingManager);
                childrenContainMappedUDT |= child.containsMappedUDT;
                this.childTypes.add(child);
            }
            this.containsMappedUDT = childrenContainMappedUDT;
            this.udtMapper = null;
            if (TypeMappings.mapsToList(klass)) {
                this.dataType = DataType.list(this.childTypes.get((int)0).dataType);
                return;
            } else if (TypeMappings.mapsToSet(klass)) {
                this.dataType = DataType.set(this.childTypes.get((int)0).dataType);
                return;
            } else {
                if (!TypeMappings.mapsToMap(klass)) throw this.fail(rootName, rootType);
                this.dataType = DataType.map(this.childTypes.get((int)0).dataType, this.childTypes.get((int)1).dataType);
            }
            return;
        } else {
            if (!(javaType instanceof Class)) throw this.fail(rootName, rootType);
            Class klass = (Class)javaType;
            if (TypeMappings.isMappedUDT(klass)) {
                this.containsMappedUDT = true;
                this.udtMapper = mappingManager.udtMapper(klass);
                this.dataType = this.udtMapper.getUserType();
                this.childTypes = Collections.emptyList();
                return;
            } else {
                this.containsMappedUDT = false;
                this.udtMapper = null;
                this.dataType = TypeMappings.getSimpleType(klass, rootName);
                this.childTypes = Collections.emptyList();
            }
        }
    }

    private IllegalArgumentException fail(String rootName, Type rootType) {
        return new IllegalArgumentException(String.format("Cannot map class %s for %s", rootType, rootName));
    }
}

