/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;

class DeclaredFrozenType {
    String name;
    boolean frozen;
    List<DeclaredFrozenType> subTypes;
    static final DeclaredFrozenType FROZEN_SIMPLE = new DeclaredFrozenType("root", true, new DeclaredFrozenType[0]);
    static final DeclaredFrozenType FROZEN_ELEMENT = new DeclaredFrozenType("collection", false, new DeclaredFrozenType("element", true, new DeclaredFrozenType[0]));
    static final DeclaredFrozenType FROZEN_MAP_KEY = new DeclaredFrozenType("map", false, new DeclaredFrozenType("key", true, new DeclaredFrozenType[0]));
    static final DeclaredFrozenType FROZEN_MAP_VALUE = new DeclaredFrozenType("map", false, new DeclaredFrozenType("key", false, new DeclaredFrozenType[0]), new DeclaredFrozenType("value", true, new DeclaredFrozenType[0]));
    static final DeclaredFrozenType FROZEN_MAP_KEY_AND_VALUE = new DeclaredFrozenType("map", false, new DeclaredFrozenType("key", true, new DeclaredFrozenType[0]), new DeclaredFrozenType("value", true, new DeclaredFrozenType[0]));
    static final DeclaredFrozenType UNFROZEN_SIMPLE = new DeclaredFrozenType("root");

    private DeclaredFrozenType(String name) {
        this(name, false, new DeclaredFrozenType[0]);
    }

    private DeclaredFrozenType(String name, boolean frozen, DeclaredFrozenType ... subTypes) {
        this.name = name;
        this.frozen = frozen;
        for (DeclaredFrozenType subType : subTypes) {
            if (this.subTypes == null) {
                this.subTypes = new ArrayList<DeclaredFrozenType>();
            }
            this.subTypes.add(subType);
        }
    }

    static DeclaredFrozenType parse(String toParse) {
        if (Strings.isNullOrEmpty(toParse)) {
            return FROZEN_SIMPLE;
        }
        return new Parser(toParse).parse();
    }

    private static class Parser {
        private final String toParse;
        private int idx;

        Parser(String toParse) {
            this.toParse = toParse;
        }

        DeclaredFrozenType parse() {
            this.skipSpaces();
            if (this.toParse.charAt(this.idx) == '\"') {
                int endQuote;
                for (endQuote = this.idx + 1; endQuote < this.toParse.length() && this.toParse.charAt(endQuote) != '\"'; ++endQuote) {
                }
                if (endQuote == this.toParse.length()) {
                    throw this.fail("could not find matching quote");
                }
                if (endQuote == this.idx + 1) {
                    throw this.fail("empty quoted identifier");
                }
                String name = this.toParse.substring(this.idx + 1, endQuote);
                this.idx = endQuote + 1;
                return new DeclaredFrozenType(name);
            }
            int n = this.skipWord();
            String nextWord = this.toParse.substring(this.idx, n).toLowerCase();
            this.idx = n;
            if ("frozen".equals(nextWord)) {
                this.skipSpaces();
                if (this.idx >= this.toParse.length() || this.toParse.charAt(this.idx) != '<') {
                    throw this.fail("expected '<'");
                }
                ++this.idx;
                DeclaredFrozenType type = this.parse();
                this.skipSpaces();
                if (this.idx >= this.toParse.length() || this.toParse.charAt(this.idx) != '>') {
                    throw this.fail("expected '>'");
                }
                ++this.idx;
                type.frozen = true;
                return type;
            }
            DeclaredFrozenType type = new DeclaredFrozenType(nextWord);
            this.skipSpaces();
            if (this.idx < this.toParse.length() && this.toParse.charAt(this.idx) == '<') {
                ++this.idx;
                type.subTypes = new ArrayList<DeclaredFrozenType>();
                while (this.idx < this.toParse.length()) {
                    type.subTypes.add(this.parse());
                    this.skipSpaces();
                    if (this.idx >= this.toParse.length()) {
                        this.fail("unterminated list of subtypes");
                        continue;
                    }
                    if (this.toParse.charAt(this.idx) == '>') {
                        ++this.idx;
                        break;
                    }
                    if (this.toParse.charAt(this.idx) != ',') {
                        this.fail("expected ','");
                        continue;
                    }
                    ++this.idx;
                }
            }
            return type;
        }

        private void skipSpaces() {
            while (this.idx < this.toParse.length() && this.isBlank(this.idx)) {
                ++this.idx;
            }
        }

        private int skipWord() {
            int i;
            if (this.idx >= this.toParse.length()) {
                throw this.fail("expected type name");
            }
            if (!this.isIdentStart(this.idx)) {
                throw this.fail("illegal character at start of type name");
            }
            for (i = this.idx; i < this.toParse.length() && this.isIdentBody(i); ++i) {
            }
            return i;
        }

        private boolean isBlank(int i) {
            char c = this.toParse.charAt(i);
            return c == ' ' || c == '\t' || c == '\n';
        }

        private boolean isIdentStart(int i) {
            char c = this.toParse.charAt(i);
            return this.isLetter(c);
        }

        private boolean isIdentBody(int i) {
            char c = this.toParse.charAt(i);
            return this.isLetter(c) || this.isDigit(c) || c == '_';
        }

        private boolean isLetter(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        private boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private IllegalArgumentException fail(String cause) {
            return new IllegalArgumentException(cause + " (" + this.toParse + " [" + this.idx + "])");
        }
    }
}

