/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.mapping.AnnotationParser;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ColumnMapper<T> {
    private final String columnName;
    private final String alias;
    protected final String fieldName;
    protected final Class<?> javaType;
    protected final DataType dataType;
    protected final Kind kind;
    protected final int position;

    protected ColumnMapper(Field field, DataType dataType, int position, AtomicInteger columnCounter) {
        this.columnName = AnnotationParser.columnName(field);
        this.alias = columnCounter != null ? AnnotationParser.newAlias(field, columnCounter.incrementAndGet()) : null;
        this.fieldName = field.getName();
        this.javaType = field.getType();
        this.dataType = dataType;
        this.kind = AnnotationParser.kind(field);
        this.position = position;
    }

    public abstract Object getValue(T var1);

    public abstract void setValue(T var1, Object var2);

    public String getColumnName() {
        return this.kind == Kind.COMPUTED ? this.columnName : QueryBuilder.quote(this.columnName);
    }

    public String getAlias() {
        return this.alias;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING_COLUMN,
        REGULAR,
        COMPUTED;

    }
}

